/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.pipeline.compression;

import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.Natives;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import me.steinborn.krypton.mod.shared.network.compression.MinecraftCompressDecoder;
import me.steinborn.krypton.mod.shared.network.compression.MinecraftCompressEncoder;
import net.minecraft.network.Connection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public class ClientConnectionMixin {
    @Shadow
    private Channel f_129468_;

    @Inject(method={"setCompressionThreshold"}, at={@At(value="HEAD")}, cancellable=true)
    public void setCompressionThreshold(int compressionThreshold, boolean validate, CallbackInfo ci) {
        if (compressionThreshold == -1) {
            this.f_129468_.pipeline().remove("decompress");
            this.f_129468_.pipeline().remove("compress");
        } else {
            MinecraftCompressDecoder decoder = (MinecraftCompressDecoder)this.f_129468_.pipeline().get("decompress");
            MinecraftCompressEncoder encoder = (MinecraftCompressEncoder)this.f_129468_.pipeline().get("compress");
            if (decoder != null && encoder != null) {
                decoder.setThreshold(compressionThreshold);
                encoder.setThreshold(compressionThreshold);
            } else {
                VelocityCompressor compressor = Natives.compress.get().create(4);
                encoder = new MinecraftCompressEncoder(compressionThreshold, compressor);
                decoder = new MinecraftCompressDecoder(compressionThreshold, validate, compressor);
                this.f_129468_.pipeline().addBefore("decoder", "decompress", (ChannelHandler)decoder);
                this.f_129468_.pipeline().addBefore("encoder", "compress", (ChannelHandler)encoder);
            }
        }
        ci.cancel();
    }
}

