/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.flushconsolidation;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import me.steinborn.krypton.mod.shared.network.util.AutoFlushUtil;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class ThreadedAnvilChunkStorageMixin {
    @Shadow
    @Final
    private Int2ObjectMap<ChunkMap.TrackedEntity> f_140150_;
    @Shadow
    @Final
    private PlayerMap f_140149_;
    @Shadow
    @Final
    private ServerLevel f_140133_;
    @Shadow
    @Final
    private ChunkMap.DistanceManager f_140145_;
    @Shadow
    private int f_140126_;

    @Shadow
    protected abstract boolean m_140329_(ServerPlayer var1);

    @Shadow
    protected abstract SectionPos m_140373_(ServerPlayer var1);

    @Shadow
    public static boolean m_200878_(int x1, int y1, int x2, int y2, int maxDistance) {
        throw new AssertionError((Object)"pedantic");
    }

    @Overwrite
    public void m_140184_(ServerPlayer player) {
        boolean movedSections;
        for (ChunkMap.TrackedEntity entityTracker : this.f_140150_.values()) {
            if (entityTracker.f_140472_ == player) {
                entityTracker.m_140487_(this.f_140133_.m_6907_());
                continue;
            }
            entityTracker.m_140497_(player);
        }
        SectionPos oldPos = player.m_8965_();
        SectionPos newPos = SectionPos.m_123194_((Entity)player);
        boolean isWatchingWorld = this.f_140149_.m_8262_(player);
        boolean noChunkGen = this.m_140329_(player);
        boolean bl = movedSections = !oldPos.equals((Object)newPos);
        if (movedSections || isWatchingWorld != noChunkGen) {
            this.m_140373_(player);
            if (!isWatchingWorld) {
                this.f_140145_.m_140828_(oldPos, player);
            }
            if (!noChunkGen) {
                this.f_140145_.m_140802_(newPos, player);
            }
            if (!isWatchingWorld && noChunkGen) {
                this.f_140149_.m_8256_(player);
            }
            if (isWatchingWorld && !noChunkGen) {
                this.f_140149_.m_8258_(player);
            }
            long oldChunkPos = ChunkPos.m_45589_((int)oldPos.m_123341_(), (int)oldPos.m_123343_());
            long newChunkPos = ChunkPos.m_45589_((int)newPos.m_123341_(), (int)newPos.m_123343_());
            this.f_140149_.m_8245_(oldChunkPos, newChunkPos, player);
            if (this.f_140133_ == player.f_19853_) {
                this.sendChunks(oldPos, player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChunks(SectionPos oldPos, ServerPlayer player) {
        AutoFlushUtil.setAutoFlush(player, false);
        try {
            int oldChunkX = oldPos.m_123170_();
            int oldChunkZ = oldPos.m_123222_();
            int newChunkX = Mth.m_14107_((double)player.m_20185_()) >> 4;
            int newChunkZ = Mth.m_14107_((double)player.m_20189_()) >> 4;
            if (Math.abs(oldChunkX - newChunkX) <= this.f_140126_ * 2 && Math.abs(oldChunkZ - newChunkZ) <= this.f_140126_ * 2) {
                int minSendChunkX = Math.min(newChunkX, oldChunkX) - this.f_140126_ - 1;
                int minSendChunkZ = Math.min(newChunkZ, oldChunkZ) - this.f_140126_ - 1;
                int maxSendChunkX = Math.max(newChunkX, oldChunkX) + this.f_140126_ + 1;
                int maxSendChunkZ = Math.max(newChunkZ, oldChunkZ) + this.f_140126_ + 1;
                for (int curX = minSendChunkX; curX <= maxSendChunkX; ++curX) {
                    for (int curZ = minSendChunkZ; curZ <= maxSendChunkZ; ++curZ) {
                        ChunkPos chunkPos = new ChunkPos(curX, curZ);
                        boolean inOld = ThreadedAnvilChunkStorageMixin.m_200878_(curX, curZ, oldChunkX, oldChunkZ, this.f_140126_);
                        boolean inNew = ThreadedAnvilChunkStorageMixin.m_200878_(curX, curZ, newChunkX, newChunkZ, this.f_140126_);
                        this.m_183754_(player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), inOld, inNew);
                    }
                }
            } else {
                ChunkPos pos;
                int curZ;
                int curX;
                for (curX = oldChunkX - this.f_140126_ - 1; curX <= oldChunkX + this.f_140126_ + 1; ++curX) {
                    for (curZ = oldChunkZ - this.f_140126_ - 1; curZ <= oldChunkZ + this.f_140126_ + 1; ++curZ) {
                        pos = new ChunkPos(curX, curZ);
                        this.m_183754_(player, pos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), true, false);
                    }
                }
                for (curX = newChunkX - this.f_140126_ - 1; curX <= newChunkX + this.f_140126_ + 1; ++curX) {
                    for (curZ = newChunkZ - this.f_140126_ - 1; curZ <= newChunkZ + this.f_140126_ + 1; ++curZ) {
                        pos = new ChunkPos(curX, curZ);
                        this.m_183754_(player, pos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
                    }
                }
            }
        }
        finally {
            AutoFlushUtil.setAutoFlush(player, true);
        }
    }

    @Shadow
    protected abstract void m_183754_(ServerPlayer var1, ChunkPos var2, MutableObject<ClientboundLevelChunkWithLightPacket> var3, boolean var4, boolean var5);

    @Inject(method={"tickEntityMovement"}, at={@At(value="HEAD")})
    public void disableAutoFlushForEntityTracking(CallbackInfo info) {
        for (ServerPlayer player : this.f_140133_.m_6907_()) {
            AutoFlushUtil.setAutoFlush(player, false);
        }
    }

    @Inject(method={"tickEntityMovement"}, at={@At(value="RETURN")})
    public void enableAutoFlushForEntityTracking(CallbackInfo info) {
        for (ServerPlayer player : this.f_140133_.m_6907_()) {
            AutoFlushUtil.setAutoFlush(player, true);
        }
    }
}

