/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.natives.compression;

import com.google.common.base.Preconditions;
import com.velocitypowered.natives.compression.CompressorUtils;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.util.BufferPreference;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class JavaVelocityCompressor
implements VelocityCompressor {
    public static final VelocityCompressorFactory FACTORY = JavaVelocityCompressor::new;
    private final Deflater deflater;
    private final Inflater inflater;
    private byte[] buf = new byte[0];
    private boolean disposed = false;

    private JavaVelocityCompressor(int level) {
        this.deflater = new Deflater(level);
        this.inflater = new Inflater();
    }

    @Override
    public void inflate(ByteBuf source, ByteBuf destination, int uncompressedSize) throws DataFormatException {
        this.ensureNotDisposed();
        int available = source.readableBytes();
        this.setInflaterInput(source);
        if (destination.hasArray()) {
            this.inflateDestinationIsHeap(destination, available, uncompressedSize);
        } else {
            if (this.buf.length == 0) {
                this.buf = new byte[8192];
            }
            while (!this.inflater.finished() && this.inflater.getBytesRead() < (long)available) {
                CompressorUtils.ensureMaxSize(destination, uncompressedSize);
                int read = this.inflater.inflate(this.buf);
                destination.writeBytes(this.buf, 0, read);
            }
        }
        this.inflater.reset();
    }

    private void setInflaterInput(ByteBuf source) {
        int available = source.readableBytes();
        if (source.hasArray()) {
            this.inflater.setInput(source.array(), source.arrayOffset() + source.readerIndex(), available);
        } else {
            byte[] inData = new byte[available];
            source.readBytes(inData);
            this.inflater.setInput(inData);
        }
    }

    private void inflateDestinationIsHeap(ByteBuf destination, int available, int max) throws DataFormatException {
        while (!this.inflater.finished() && this.inflater.getBytesRead() < (long)available) {
            if (!destination.isWritable()) {
                CompressorUtils.ensureMaxSize(destination, max);
                destination.ensureWritable(8192);
            }
            CompressorUtils.ensureMaxSize(destination, max);
            int produced = this.inflater.inflate(destination.array(), destination.arrayOffset() + destination.writerIndex(), destination.writableBytes());
            destination.writerIndex(destination.writerIndex() + produced);
        }
    }

    @Override
    public void deflate(ByteBuf source, ByteBuf destination) throws DataFormatException {
        this.ensureNotDisposed();
        this.setDeflaterInput(source);
        this.deflater.finish();
        if (destination.hasArray()) {
            this.deflateDestinationIsHeap(destination);
        } else {
            if (this.buf.length == 0) {
                this.buf = new byte[8192];
            }
            while (!this.deflater.finished()) {
                int bytes = this.deflater.deflate(this.buf);
                destination.writeBytes(this.buf, 0, bytes);
            }
        }
        this.deflater.reset();
    }

    private void setDeflaterInput(ByteBuf source) {
        if (source.hasArray()) {
            this.deflater.setInput(source.array(), source.arrayOffset() + source.readerIndex(), source.readableBytes());
        } else {
            byte[] inData = new byte[source.readableBytes()];
            source.readBytes(inData);
            this.deflater.setInput(inData);
        }
    }

    private void deflateDestinationIsHeap(ByteBuf destination) {
        while (!this.deflater.finished()) {
            if (!destination.isWritable()) {
                destination.ensureWritable(8192);
            }
            int produced = this.deflater.deflate(destination.array(), destination.arrayOffset() + destination.writerIndex(), destination.writableBytes());
            destination.writerIndex(destination.writerIndex() + produced);
        }
    }

    @Override
    public void close() {
        this.disposed = true;
        this.deflater.end();
        this.inflater.end();
    }

    private void ensureNotDisposed() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Object already disposed");
    }

    @Override
    public BufferPreference preferredBufferType() {
        return BufferPreference.HEAP_PREFERRED;
    }
}

