/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes;

import com.nick.chimes.ClientRegisteries;
import com.nick.chimes.client.ChimesSettings;
import com.nick.chimes.client.particles.Leaf;
import com.nick.chimes.client.tile.AmethystChimesRenderer;
import com.nick.chimes.client.tile.BambooChimesRenderer;
import com.nick.chimes.client.tile.CopperChimesRenderer;
import com.nick.chimes.client.tile.IronChimesRenderer;
import com.nick.chimes.common.blockentity.AmethystChimesTile;
import com.nick.chimes.common.blockentity.BambooChimesTile;
import com.nick.chimes.common.blockentity.CopperChimesTile;
import com.nick.chimes.common.blockentity.MetalChimesTile;
import com.nick.chimes.common.blocks.AmethystChimes;
import com.nick.chimes.common.blocks.BambooChimes;
import com.nick.chimes.common.blocks.BambooChimesCarved;
import com.nick.chimes.common.blocks.CopperChimes;
import com.nick.chimes.common.blocks.MetalChimes;
import com.nick.chimes.util.lists.ChimesBlocks;
import com.nick.chimes.util.lists.ChimesParticles;
import com.nick.chimes.util.lists.ChimesSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="chimes")
public class Chimes {
    public static final String modid = "chimes";

    public Chimes() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::ClientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ChimesSettings.SPEC);
        ChimesParticles.PARTICLES.register(modEventBus);
    }

    public void setup(FMLCommonSetupEvent event) {
    }

    private void ClientSetup(FMLClientSetupEvent event) {
        ClientRegisteries.registerExtensionPoint();
        RenderType CUTOUT = RenderType.m_110463_();
        BlockEntityRenderers.m_173590_(ChimesBlocks.BAMBOOCHIMES_TILE, BambooChimesRenderer::new);
        BlockEntityRenderers.m_173590_(ChimesBlocks.METALCHIMES_TILE, IronChimesRenderer::new);
        BlockEntityRenderers.m_173590_(ChimesBlocks.COPPERCHIMES_TILE, CopperChimesRenderer::new);
        BlockEntityRenderers.m_173590_(ChimesBlocks.AMETHYSTCHIMES_TILE, AmethystChimesRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)ChimesBlocks.BAMBOOCHIMES, (RenderType)CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)ChimesBlocks.METALCHIMES, (RenderType)CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)ChimesBlocks.COPPERCHIMES, (RenderType)CUTOUT);
        ItemBlockRenderTypes.setRenderLayer((Block)ChimesBlocks.STRIPPEDBAMBOOCHIMES, (RenderType)CUTOUT);
    }

    @Mod.EventBusSubscriber(modid="chimes", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new BambooChimes(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(0.5f, 0.25f).m_60955_().m_60918_(SoundType.f_56754_)).setRegistryName("bamboo_chimes"), (Block)new BambooChimesCarved(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(0.5f, 0.25f).m_60955_().m_60918_(SoundType.f_56756_)).setRegistryName("carved_bamboo_chimes"), (Block)new MetalChimes(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76405_).m_60913_(1.0f, 0.25f).m_60955_().m_60918_(SoundType.f_56728_)).setRegistryName("iron_chimes"), (Block)new CopperChimes(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.0f, 0.25f).m_60955_().m_60918_(SoundType.f_154663_)).setRegistryName("copper_chimes"), (Block)new AmethystChimes(BlockBehaviour.Properties.m_60939_((Material)Material.f_164531_).m_60913_(0.4f, 0.25f).m_60918_(SoundType.f_154657_).m_60955_().m_60953_(value -> 9)).setRegistryName("amethyst_chimes")});
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockItem((Block)ChimesBlocks.BAMBOOCHIMES, new Item.Properties().m_41491_(CreativeModeTab.f_40750_)).setRegistryName("bamboo_chimes"), (Item)new BlockItem((Block)ChimesBlocks.STRIPPEDBAMBOOCHIMES, new Item.Properties().m_41491_(CreativeModeTab.f_40750_)).setRegistryName("carved_bamboo_chimes"), (Item)new BlockItem((Block)ChimesBlocks.METALCHIMES, new Item.Properties().m_41491_(CreativeModeTab.f_40750_)).setRegistryName("iron_chimes"), (Item)new BlockItem((Block)ChimesBlocks.COPPERCHIMES, new Item.Properties().m_41491_(CreativeModeTab.f_40750_)).setRegistryName("copper_chimes"), (Item)new BlockItem((Block)ChimesBlocks.AMETHYSTCHIMES, new Item.Properties().m_41491_(CreativeModeTab.f_40750_)).setRegistryName("amethyst_chimes")});
        }

        @SubscribeEvent
        public static void onBlockEntityRegistry(RegistryEvent.Register<BlockEntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new BlockEntityType[]{(BlockEntityType)BlockEntityType.Builder.m_155273_(BambooChimesTile::new, (Block[])new Block[]{ChimesBlocks.STRIPPEDBAMBOOCHIMES, ChimesBlocks.BAMBOOCHIMES}).m_58966_(null).setRegistryName("bamboo_chimes_tile"), (BlockEntityType)BlockEntityType.Builder.m_155273_(MetalChimesTile::new, (Block[])new Block[]{ChimesBlocks.METALCHIMES}).m_58966_(null).setRegistryName("metal_chimes_tile"), (BlockEntityType)BlockEntityType.Builder.m_155273_(CopperChimesTile::new, (Block[])new Block[]{ChimesBlocks.COPPERCHIMES}).m_58966_(null).setRegistryName("copper_chimes_tile"), (BlockEntityType)BlockEntityType.Builder.m_155273_(AmethystChimesTile::new, (Block[])new Block[]{ChimesBlocks.AMETHYSTCHIMES}).m_58966_(null).setRegistryName("amethyst_chimes_tile")});
        }

        @SubscribeEvent
        public static void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{ChimesSounds.BAMBOOCHIME, ChimesSounds.BAMBOOTUNE, ChimesSounds.BAMBOOCHIMING, ChimesSounds.IRONCHIME, ChimesSounds.IRONCHIMING, ChimesSounds.COPPERCHIME, ChimesSounds.COPPERCHIMING, ChimesSounds.AMETHYSTTWINKLE});
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        @OnlyIn(value=Dist.CLIENT)
        public static void onParticleTypeRegistry(ParticleFactoryRegisterEvent event) {
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ChimesParticles.LEAF.get(), Leaf.Factory::new);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(BambooChimesRenderer.BAMBOO_CHIMES_LAYER, BambooChimesRenderer::createBodyLayer);
            event.registerLayerDefinition(IronChimesRenderer.IRON_CHIMES_LAYER, IronChimesRenderer::createBodyLayer);
            event.registerLayerDefinition(CopperChimesRenderer.COPPER_CHIMES_LAYER, CopperChimesRenderer::createBodyLayer);
            event.registerLayerDefinition(AmethystChimesRenderer.AMETHYST_CHIMES_RENDERER, AmethystChimesRenderer::createBodyLayer);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onTextureStitchRegistry(TextureStitchEvent.Pre event) {
            event.addSprite(new ResourceLocation(Chimes.modid, "block/bamboo_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/bamboo_chimes_carved"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/metal_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/copper_chimes"));
            event.addSprite(new ResourceLocation(Chimes.modid, "block/amethyst_chimes"));
        }
    }
}

