/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.effective_fg.registry;

import com.bottomtextdanny.effective_fg.client.particle.DropletParticle;
import com.bottomtextdanny.effective_fg.client.particle.LavaSplashParticle;
import com.bottomtextdanny.effective_fg.client.particle.RippleParticle;
import com.bottomtextdanny.effective_fg.client.particle.SplashParticle;
import com.bottomtextdanny.effective_fg.client.particle.WaterfallCloudParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="effective_fg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ParticleRegistry {
    public static final DeferredRegister<ParticleType<?>> ENTRIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"effective_fg");
    public static final RegistryObject<SimpleParticleType> DROPLET = ParticleRegistry.defer("droplet");
    public static final RegistryObject<SimpleParticleType> LAVA_SPLASH = ParticleRegistry.defer("lava_splash");
    public static final RegistryObject<SimpleParticleType> RIPPLE = ParticleRegistry.defer("ripple");
    public static final RegistryObject<SimpleParticleType> SPLASH = ParticleRegistry.defer("splash");
    public static final RegistryObject<SimpleParticleType> WATERFALL_CLOUD = ParticleRegistry.defer("waterfall_cloud");

    private static RegistryObject<SimpleParticleType> defer(String name) {
        return ENTRIES.register(name, () -> new SimpleParticleType(true));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerParticleTypes(ParticleFactoryRegisterEvent event) {
        if (DROPLET.isPresent()) {
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)DROPLET.get(), DropletParticle.Factory::new);
        }
        if (RIPPLE.isPresent()) {
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)RIPPLE.get(), RippleParticle.Factory::new);
        }
        if (LAVA_SPLASH.isPresent()) {
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)LAVA_SPLASH.get(), LavaSplashParticle.Factory::new);
        }
        if (SPLASH.isPresent()) {
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)SPLASH.get(), SplashParticle.Factory::new);
        }
        if (WATERFALL_CLOUD.isPresent()) {
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)WATERFALL_CLOUD.get(), WaterfallCloudParticle.Factory::new);
        }
    }
}

