/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.utils;

import java.util.Arrays;
import java.util.Map;
import me.cominixo.betterf3.utils.FpsEnum;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.StringUtils;

public final class Utils {
    public static final int START_X_POS = 200;
    public static int xPos = 200;
    public static long lastAnimationUpdate = 0L;
    public static boolean closingAnimation = false;

    private Utils() {
    }

    public static FpsEnum fpsColor(int currentFps) {
        if (currentFps >= 60) {
            return FpsEnum.HIGH;
        }
        if (currentFps >= 20) {
            return FpsEnum.MEDIUM;
        }
        return FpsEnum.LOW;
    }

    public static ChatFormatting percentColor(int percent) {
        if (percent >= 90) {
            return ChatFormatting.RED;
        }
        if (percent >= 60) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }

    public static String facingString(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> I18n.m_118938_((String)"text.betterf3.line.negative_z", (Object[])new Object[0]);
            case Direction.SOUTH -> I18n.m_118938_((String)"text.betterf3.line.positive_z", (Object[])new Object[0]);
            case Direction.WEST -> I18n.m_118938_((String)"text.betterf3.line.negative_x", (Object[])new Object[0]);
            case Direction.EAST -> I18n.m_118938_((String)"text.betterf3.line.positive_x", (Object[])new Object[0]);
            default -> "";
        };
    }

    public static MutableComponent styledText(Object string, TextColor color) {
        if (string == null) {
            string = "";
        }
        return new TextComponent(string.toString()).m_130938_(style -> style.m_131148_(color));
    }

    public static String enumToString(Enum<?> enumToConvert) {
        return StringUtils.capitalize((String)enumToConvert.toString().replace("_", " "));
    }

    public static Component formattedFromString(String string, TextColor nameColor, TextColor valueColor) {
        String[] split = string.split(":");
        if (string.contains(":")) {
            MutableComponent name = Utils.styledText(split[0], nameColor);
            MutableComponent value = Utils.styledText(String.join((CharSequence)":", Arrays.asList(split).subList(1, split.length)), valueColor);
            return name.m_7220_((Component)new TextComponent(":")).m_7220_((Component)value);
        }
        return new TextComponent(string);
    }

    public static String propertyToString(Map.Entry<Property<?>, Comparable<?>> propEntry) {
        Property<?> key = propEntry.getKey();
        Comparable<?> value = propEntry.getValue();
        Object newValue = Util.m_137453_(key, value);
        if (Boolean.TRUE.equals(value)) {
            newValue = ChatFormatting.GREEN + (String)newValue;
        } else if (Boolean.FALSE.equals(value)) {
            newValue = ChatFormatting.RED + (String)newValue;
        }
        return key.m_61708_() + ": " + (String)newValue;
    }
}

