/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.platform.Window;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TextColor;
import org.apache.commons.lang3.ArrayUtils;

public class SystemModule
extends BaseModule {
    public SystemModule() {
        this.defaultNameColor = TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD);
        this.defaultValueColor = TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("java_version"));
        this.lines.add(new DebugLine("memory_usage"));
        this.lines.add(new DebugLine("allocated_memory"));
        this.lines.add(new DebugLine("cpu"));
        this.lines.add(new DebugLine("display"));
        this.lines.add(new DebugLine("gpu"));
        this.lines.add(new DebugLine("opengl_version"));
        this.lines.add(new DebugLine("gpu_driver"));
        for (DebugLine line : this.lines) {
            line.inReducedDebug = true;
        }
    }

    @Override
    public void update(Minecraft client) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        Window window = client.m_91268_();
        String javaVersion = String.format("%s %dbit", System.getProperty("java.version"), client.m_91103_() ? 64 : 32);
        String memoryUsage = String.format("% 2d%% %03d/%03d MB", usedMemory * 100L / maxMemory, usedMemory / 1024L / 1024L, maxMemory / 1024L / 1024L);
        String allocatedMemory = String.format("% 2d%% %03dMB", totalMemory * 100L / maxMemory, totalMemory / 1024L / 1024L);
        String displayInfo = String.format("%d x %d (%s)", window.m_85441_(), window.m_85442_(), GlUtil.m_84818_());
        Object[] versionSplit = GlUtil.m_84821_().split(" ");
        String openGlVersion = versionSplit[0];
        String gpuDriverVersion = String.join((CharSequence)" ", (CharSequence[])ArrayUtils.remove((Object[])versionSplit, (int)0));
        ((DebugLine)this.lines.get(0)).value(javaVersion);
        ((DebugLine)this.lines.get(1)).value(Utils.percentColor((int)(usedMemory * 100L / maxMemory)) + memoryUsage);
        ((DebugLine)this.lines.get(2)).value(allocatedMemory);
        ((DebugLine)this.lines.get(3)).value(GlUtil.m_84819_());
        ((DebugLine)this.lines.get(4)).value(displayInfo);
        ((DebugLine)this.lines.get(5)).value(GlUtil.m_84820_());
        ((DebugLine)this.lines.get(6)).value(openGlVersion);
        ((DebugLine)this.lines.get(7)).value(gpuDriverVersion);
    }
}

