/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item;

import dev.murad.shipping.entity.custom.tug.TugFrontPart;
import dev.murad.shipping.util.LinkableEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SpringItem
extends Item {
    private TranslatableComponent springInfo = new TranslatableComponent("item.littlelogistics.spring.description");

    public SpringItem(Item.Properties properties) {
        super(properties);
    }

    public void onUsedOnEntity(ItemStack stack, Player player, Level world, Entity target) {
        if (target instanceof TugFrontPart) {
            target = ((TugFrontPart)target).getParent();
        }
        if (world.f_46443_) {
            return;
        }
        switch (SpringItem.getState(stack)) {
            case WAITING_NEXT: {
                this.createSpringHelper(stack, player, world, target);
                break;
            }
            default: {
                this.setDominant(world, stack, target);
            }
        }
    }

    private void createSpringHelper(ItemStack stack, Player player, Level world, Entity target) {
        LinkableEntity d;
        Entity dominant = this.getDominant(world, stack);
        if (dominant == null) {
            return;
        }
        if (dominant == target) {
            player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.spring.notToSelf"), true);
        } else if (dominant instanceof LinkableEntity && (d = (LinkableEntity)dominant).linkEntities(player, target) && !player.m_7500_()) {
            stack.m_41774_(1);
        }
        this.resetLinked(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)this.springInfo);
    }

    private void setDominant(Level worldIn, ItemStack stack, Entity entity) {
        SpringItem.nbt(stack).m_128405_("linked", entity.m_142049_());
    }

    private Entity getDominant(Level worldIn, ItemStack stack) {
        int id = SpringItem.nbt(stack).m_128451_("linked");
        return worldIn.m_6815_(id);
    }

    private static CompoundTag nbt(ItemStack stack) {
        if (stack.m_41783_() == null) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }

    private void resetLinked(ItemStack itemstack) {
        SpringItem.nbt(itemstack).m_128473_("linked");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        this.resetLinked(playerIn.m_21120_(handIn));
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public static State getState(ItemStack stack) {
        if (SpringItem.nbt(stack).m_128441_("linked")) {
            return State.WAITING_NEXT;
        }
        return State.READY;
    }

    public static enum State {
        WAITING_NEXT,
        READY;

    }
}

