/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.data.client;

import dev.murad.shipping.block.dock.BargeDockBlock;
import dev.murad.shipping.block.dock.TugDockBlock;
import dev.murad.shipping.block.energy.VesselChargerBlock;
import dev.murad.shipping.block.fluid.FluidHopperBlock;
import dev.murad.shipping.block.guide_rail.CornerGuideRailBlock;
import dev.murad.shipping.block.vessel_detector.VesselDetectorBlock;
import dev.murad.shipping.setup.ModBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "littlelogistics", exFileHelper);
    }

    public static ResourceLocation getBlTx(String name) {
        return new ResourceLocation("littlelogistics", String.format("block/%s", name));
    }

    private ModelFile getTugDockModel(BlockState state) {
        String inv = (Boolean)state.m_61143_((Property)TugDockBlock.INVERTED) != false ? "_inv" : "";
        String powered = (Boolean)state.m_61143_((Property)TugDockBlock.POWERED) != false ? "_powered" : "";
        return this.models().orientable("tug_dock" + inv + powered, ModBlockStateProvider.getBlTx("tug_dock"), ModBlockStateProvider.getBlTx("tug_dock_front" + powered), ModBlockStateProvider.getBlTx("tug_dock_top" + inv));
    }

    private ModelFile getCornerGuideRailModel(BlockState state) {
        String inv = (Boolean)state.m_61143_((Property)CornerGuideRailBlock.INVERTED) != false ? "_inv" : "";
        return this.models().orientable("guide_rail_corner" + inv, ModBlockStateProvider.getBlTx("guide_rail_side"), ModBlockStateProvider.getBlTx("guide_rail_front" + inv), ModBlockStateProvider.getBlTx("guide_rail_top" + inv));
    }

    private ModelFile getTugGuideRailModel(BlockState state) {
        return this.models().orientable("guide_rail_tug", ModBlockStateProvider.getBlTx("guide_rail_side"), ModBlockStateProvider.getBlTx("guide_rail_side"), ModBlockStateProvider.getBlTx("guide_rail_front"));
    }

    private ModelFile getVesselDetectorModel(BlockState state) {
        String powered = (Boolean)state.m_61143_((Property)VesselDetectorBlock.POWERED) != false ? "_powered" : "";
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("vessel_detector" + powered, this.modLoc("orientable_with_back"))).texture("side", ModBlockStateProvider.getBlTx("vessel_detector_side"))).texture("front", ModBlockStateProvider.getBlTx("vessel_detector_front"))).texture("back", ModBlockStateProvider.getBlTx("vessel_detector_back" + powered));
    }

    private ModelFile getBargeDockModel(BlockState state) {
        String inv = (Boolean)state.m_61143_((Property)BargeDockBlock.EXTRACT_MODE) != false ? "_extract" : "";
        return this.models().orientable("barge_dock" + inv, ModBlockStateProvider.getBlTx("barge_dock"), ModBlockStateProvider.getBlTx("barge_dock_front" + inv), ModBlockStateProvider.getBlTx("barge_dock_top"));
    }

    private int xRotFromDir(Direction direction) {
        switch (direction) {
            case DOWN: {
                return 270;
            }
            case UP: {
                return 90;
            }
        }
        return 0;
    }

    protected void registerStatesAndModels() {
        this.getVariantBuilder((Block)ModBlocks.TUG_DOCK.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getTugDockModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)TugDockBlock.FACING)).m_122424_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.BARGE_DOCK.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getBargeDockModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)BargeDockBlock.FACING)).m_122424_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.GUIDE_RAIL_CORNER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getCornerGuideRailModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)CornerGuideRailBlock.FACING)).m_122424_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.VESSEL_DETECTOR.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getVesselDetectorModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)VesselDetectorBlock.FACING)).m_122424_().m_122435_()).rotationX(this.xRotFromDir(((Direction)state.m_61143_((Property)VesselDetectorBlock.FACING)).m_122424_())).build());
        this.getVariantBuilder((Block)ModBlocks.GUIDE_RAIL_TUG.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getTugGuideRailModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)CornerGuideRailBlock.FACING)).m_122427_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.FLUID_HOPPER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().withExistingParent("fluid_hopper", this.modLoc("fluid_hopper_parent_model"))).rotationY((int)((Direction)state.m_61143_((Property)FluidHopperBlock.FACING)).m_122427_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.VESSEL_CHARGER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().withExistingParent("vessel_charger", this.modLoc("vessel_charger_parent_model"))).rotationY((int)((Direction)state.m_61143_((Property)VesselChargerBlock.FACING)).m_122424_().m_122435_()).build());
        this.getVariantBuilder((Block)ModBlocks.RAPID_HOPPER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.getRapidHopperModel((BlockState)state)).rotationY((int)((Direction)state.m_61143_((Property)HopperBlock.f_54021_)).m_122424_().m_122435_()).build());
    }

    private BlockModelBuilder getRapidHopperModel(BlockState state) {
        String side = ((Direction)state.m_61143_((Property)HopperBlock.f_54021_)).equals((Object)Direction.DOWN) ? "" : "_side";
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("rapid_hopper" + side, this.mcLoc("hopper" + side))).texture("particle", ModBlockStateProvider.getBlTx("rapid_hopper_outside"))).texture("top", ModBlockStateProvider.getBlTx("rapid_hopper_top"))).texture("side", ModBlockStateProvider.getBlTx("rapid_hopper_outside"))).texture("inside", ModBlockStateProvider.getBlTx("rapid_hopper_inside"));
    }
}

