/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.dock;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.block.IVesselLoader;
import dev.murad.shipping.block.dock.AbstractDockTileEntity;
import dev.murad.shipping.block.dock.BargeDockTileEntity;
import dev.murad.shipping.block.dock.TugDockBlock;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.custom.barge.AbstractBargeEntity;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import dev.murad.shipping.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TugDockTileEntity
extends AbstractDockTileEntity {
    public TugDockTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public TugDockTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntitiesTypes.TUG_DOCK.get(), pos, state);
    }

    private boolean handleItemHopper(VesselEntity tugEntity, HopperBlockEntity hopper) {
        if (!(tugEntity instanceof Container)) {
            return false;
        }
        return InventoryUtils.mayMoveIntoInventory((Container)tugEntity, (Container)hopper);
    }

    @Override
    public boolean holdVessel(VesselEntity tug, Direction direction) {
        if (!(tug instanceof AbstractTugEntity) || !((Direction)this.m_58900_().m_61143_((Property)TugDockBlock.FACING)).m_122424_().equals((Object)direction) || tug.m_6350_().equals((Object)this.getRowDirection((Direction)this.m_58900_().m_61143_((Property)TugDockBlock.FACING)))) {
            return false;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)TugDockBlock.POWERED)).booleanValue()) {
            return true;
        }
        if (this.getHopper().map(hopper -> this.handleItemHopper(tug, (HopperBlockEntity)hopper)).orElse(this.getVesselLoader().map(l -> l.holdVessel(tug, IVesselLoader.Mode.EXPORT)).orElse(false)).booleanValue()) {
            return true;
        }
        List<Pair<AbstractBargeEntity, BargeDockTileEntity>> barges = this.getBargeDockPairs((AbstractTugEntity)tug);
        return barges.stream().map(pair -> ((BargeDockTileEntity)((Object)((Object)pair.getSecond()))).holdVessel((VesselEntity)pair.getFirst(), direction)).reduce(false, Boolean::logicalOr) != false;
    }

    @Override
    protected BlockPos getTargetBlockPos() {
        return this.m_58899_().m_7494_();
    }

    private List<Pair<AbstractBargeEntity, BargeDockTileEntity>> getBargeDockPairs(AbstractTugEntity tug) {
        List<VesselEntity> barges = tug.getTrain().asListOfTugged();
        List<BargeDockTileEntity> docks = this.getBargeDocks();
        return IntStream.range(0, Math.min(barges.size(), docks.size())).mapToObj(i -> new Pair((Object)((AbstractBargeEntity)barges.get(i)), (Object)((BargeDockTileEntity)((Object)((Object)docks.get(i)))))).collect(Collectors.toList());
    }

    private List<BargeDockTileEntity> getBargeDocks() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TugDockBlock.FACING);
        Direction rowDirection = this.getRowDirection(facing);
        ArrayList<BargeDockTileEntity> docks = new ArrayList<BargeDockTileEntity>();
        Optional<BargeDockTileEntity> dock = this.getNextBargeDock(rowDirection, this.m_58899_());
        while (dock.isPresent()) {
            docks.add(dock.get());
            dock = this.getNextBargeDock(rowDirection, dock.get().m_58899_());
        }
        return docks;
    }

    private Direction getRowDirection(Direction facing) {
        return (Boolean)this.m_58900_().m_61143_((Property)TugDockBlock.INVERTED) != false ? facing.m_122427_() : facing.m_122428_();
    }

    private Optional<BargeDockTileEntity> getNextBargeDock(Direction rowDirection, BlockPos pos) {
        BlockPos next = pos.m_142300_(rowDirection);
        return Optional.ofNullable(this.f_58857_.m_7702_(next)).filter(e -> e instanceof BargeDockTileEntity).map(e -> (BargeDockTileEntity)((Object)e));
    }
}

