/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.container.EnergyTugScreen;
import dev.murad.shipping.entity.container.FishingBargeScreen;
import dev.murad.shipping.entity.container.SteamTugScreen;
import dev.murad.shipping.item.container.TugRouteScreen;
import dev.murad.shipping.setup.ModItemModelProperties;
import dev.murad.shipping.setup.ModMenuTypes;
import dev.murad.shipping.setup.Registration;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="littlelogistics")
public class ShippingMod {
    public static final String MOD_ID = "littlelogistics";
    private static final Logger LOGGER = LogManager.getLogger();

    public ShippingMod() {
        Registration.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ShippingConfig.Client.SPEC, "littlelogistics-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ShippingConfig.Server.SPEC, "littlelogistics-server.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.TUG_CONTAINER.get()), SteamTugScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.ENERGY_TUG_CONTAINER.get()), EnergyTugScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.FISHING_BARGE_CONTAINER.get()), FishingBargeScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.TUG_ROUTE_CONTAINER.get()), TugRouteScreen::new);
        event.enqueueWork(ModItemModelProperties::register);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

