/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.craft;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingModuleItem
extends ModuleItem {
    public final int inputSlots;
    public final int outputSlots;
    private final int speed;

    public CraftingModuleItem(String name, ModuleTier tier) {
        super(name);
        this.inputSlots = tier.forTier(1, 4, 9);
        this.outputSlots = tier.forTier(1, 2, 4);
        this.speed = tier.forTier(20, 10, 5);
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeBlockEntity tile, IModule other) {
        return true;
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeBlockEntity tile) {
        return true;
    }

    @Override
    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeBlockEntity tile, int windowId, Inventory inv, Player player, int moduleIndex) {
        return new CraftingModuleContainer(Registry.craftingModuleContainer, windowId, player, tile.m_58899_(), moduleIndex);
    }

    @Override
    public boolean canNetworkSee(ItemStack module, PipeBlockEntity tile) {
        return false;
    }

    @Override
    public boolean canAcceptItem(ItemStack module, PipeBlockEntity tile, ItemStack stack) {
        return false;
    }

    @Override
    public void tick(ItemStack module, PipeBlockEntity tile) {
        ItemStack remain;
        ItemEquality[] equalityTypes;
        if (!tile.shouldWorkNow(this.speed) || !tile.canWork()) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(tile.m_58904_());
        if (!tile.craftIngredientRequests.isEmpty()) {
            network.startProfile("crafting_ingredients");
            NetworkLock request = tile.craftIngredientRequests.peek();
            equalityTypes = ItemFilter.getEqualityTypes(tile);
            Pair<BlockPos, ItemStack> dest = tile.getAvailableDestination(request.stack, true, true);
            if (dest != null) {
                ItemStack requestRemain = network.requestExistingItem(request.location, tile.m_58899_(), (BlockPos)dest.getLeft(), request, (ItemStack)dest.getRight(), equalityTypes);
                network.resolveNetworkLock(request);
                tile.craftIngredientRequests.remove();
                remain = request.stack.m_41777_();
                remain.m_41774_(((ItemStack)dest.getRight()).m_41613_() - requestRemain.m_41613_());
                if (!remain.m_41619_()) {
                    NetworkLock remainRequest = new NetworkLock(request.location, remain);
                    tile.craftIngredientRequests.add(remainRequest);
                    network.createNetworkLock(remainRequest);
                }
            }
            network.endProfile();
        }
        if (!tile.craftResultRequests.isEmpty()) {
            network.startProfile("crafting_results");
            List<NetworkLocation> items = network.getOrderedNetworkItems(tile.m_58899_());
            equalityTypes = ItemFilter.getEqualityTypes(tile);
            for (Pair<BlockPos, ItemStack> request : tile.craftResultRequests) {
                Pair<BlockPos, ItemStack> dest;
                remain = ((ItemStack)request.getRight()).m_41777_();
                PipeBlockEntity destPipe = network.getPipe((BlockPos)request.getLeft());
                if (destPipe == null || (dest = destPipe.getAvailableDestinationOrConnectable(remain, true, true)) == null) continue;
                for (NetworkLocation item : items) {
                    ItemStack requestRemain = network.requestExistingItem(item, (BlockPos)request.getLeft(), (BlockPos)dest.getLeft(), null, (ItemStack)dest.getRight(), equalityTypes);
                    remain.m_41774_(((ItemStack)dest.getRight()).m_41613_() - requestRemain.m_41613_());
                    if (!remain.m_41619_()) continue;
                    break;
                }
                if (remain.m_41613_() == ((ItemStack)request.getRight()).m_41613_()) continue;
                tile.craftResultRequests.remove(request);
                if (!remain.m_41619_()) {
                    tile.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)((BlockPos)request.getLeft()), (Object)remain));
                }
                network.endProfile();
                return;
            }
            network.endProfile();
        }
    }

    @Override
    public List<ItemStack> getAllCraftables(ItemStack module, PipeBlockEntity tile) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStackHandler output = this.getOutput(module);
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack stack = output.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ret.add(stack);
        }
        return ret;
    }

    @Override
    public int getCraftableAmount(ItemStack module, PipeBlockEntity tile, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        PipeNetwork network = PipeNetwork.get(tile.m_58904_());
        List<NetworkLocation> items = network.getOrderedNetworkItems(tile.m_58899_());
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        ItemStackHandler input = this.getInput(module);
        int craftable = 0;
        ItemStackHandler output = this.getOutput(module);
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack out = output.getStackInSlot(i);
            if (out.m_41619_() || !ItemEquality.compareItems(out, stack, equalityTypes)) continue;
            int availableCrafts = CraftingTerminalBlockEntity.getAvailableCrafts(tile, input.getSlots(), arg_0 -> ((ItemStackHandler)input).getStackInSlot(arg_0), k -> true, s -> items, unavailableConsumer, CraftingModuleItem.addDependency(dependencyChain, module), equalityTypes);
            if (availableCrafts <= 0) continue;
            craftable += out.m_41613_() * availableCrafts;
        }
        return craftable;
    }

    @Override
    public ItemStack craft(ItemStack module, PipeBlockEntity tile, BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        int craftableAmount = this.getCraftableAmount(module, tile, unavailableConsumer, stack, dependencyChain);
        if (craftableAmount <= 0) {
            return stack;
        }
        PipeNetwork network = PipeNetwork.get(tile.m_58904_());
        List<NetworkLocation> items = network.getOrderedNetworkItems(tile.m_58899_());
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        int resultAmount = this.getResultAmountPerCraft(module, stack, equalityTypes);
        int requiredCrafts = Mth.m_14167_((float)((float)stack.m_41613_() / (float)resultAmount));
        int craftableCrafts = Mth.m_14167_((float)((float)craftableAmount / (float)resultAmount));
        int toCraft = Math.min(craftableCrafts, requiredCrafts);
        ItemStackHandler input = this.getInput(module);
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack in = input.getStackInSlot(i);
            if (in.m_41619_()) continue;
            ItemStack copy = in.m_41777_();
            copy.m_41764_(in.m_41613_() * toCraft);
            Pair<List<NetworkLock>, ItemStack> ret = ItemTerminalBlockEntity.requestItemLater(tile.m_58904_(), tile.m_58899_(), items, unavailableConsumer, copy, CraftingModuleItem.addDependency(dependencyChain, module), equalityTypes);
            tile.craftIngredientRequests.addAll((Collection)ret.getLeft());
        }
        ItemStack remain = stack.m_41777_();
        remain.m_41774_(resultAmount * toCraft);
        ItemStack result = stack.m_41777_();
        result.m_41774_(remain.m_41613_());
        tile.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)destPipe, (Object)result));
        return remain;
    }

    public ItemStackHandler getInput(ItemStack module) {
        ItemStackHandler handler = new ItemStackHandler(this.inputSlots);
        if (module.m_41782_()) {
            handler.deserializeNBT(module.m_41783_().m_128469_("input"));
        }
        return handler;
    }

    public ItemStackHandler getOutput(ItemStack module) {
        ItemStackHandler handler = new ItemStackHandler(this.outputSlots);
        if (module.m_41782_()) {
            handler.deserializeNBT(module.m_41783_().m_128469_("output"));
        }
        return handler;
    }

    public void save(ItemStackHandler input, ItemStackHandler output, ItemStack module) {
        CompoundTag tag = module.m_41784_();
        if (input != null) {
            tag.m_128365_("input", (Tag)input.serializeNBT());
        }
        if (output != null) {
            tag.m_128365_("output", (Tag)output.serializeNBT());
        }
    }

    private int getResultAmountPerCraft(ItemStack module, ItemStack stack, ItemEquality ... equalityTypes) {
        ItemStackHandler output = this.getOutput(module);
        int resultAmount = 0;
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack out = output.getStackInSlot(i);
            if (!ItemEquality.compareItems(stack, out, equalityTypes)) continue;
            resultAmount += out.m_41613_();
        }
        return resultAmount;
    }

    private static Stack<ItemStack> addDependency(Stack<ItemStack> deps, ItemStack module) {
        deps = (Stack)deps.clone();
        deps.push(module);
        return deps;
    }
}

