/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends BaseEntityBlock {
    public static final Map<Direction, EnumProperty<ConnectionType>> DIRECTIONS = new HashMap<Direction, EnumProperty<ConnectionType>>();
    private static final Map<Pair<BlockState, BlockState>, VoxelShape> SHAPE_CACHE = new HashMap<Pair<BlockState, BlockState>, VoxelShape>();
    private static final Map<Pair<BlockState, BlockState>, VoxelShape> COLL_SHAPE_CACHE = new HashMap<Pair<BlockState, BlockState>, VoxelShape>();
    private static final VoxelShape CENTER_SHAPE = PipeBlock.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final Map<Direction, VoxelShape> DIR_SHAPES = ImmutableMap.builder().put((Object)Direction.UP, (Object)PipeBlock.m_49796_((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).put((Object)Direction.DOWN, (Object)PipeBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)).put((Object)Direction.NORTH, (Object)PipeBlock.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0)).put((Object)Direction.SOUTH, (Object)PipeBlock.m_49796_((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0)).put((Object)Direction.EAST, (Object)PipeBlock.m_49796_((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0)).put((Object)Direction.WEST, (Object)PipeBlock.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0)).build();

    public PipeBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(2.0f).m_60918_(SoundType.f_56742_).m_60955_());
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        for (EnumProperty<ConnectionType> prop : DIRECTIONS.values()) {
            state = (BlockState)state.m_61124_(prop, (Comparable)((Object)ConnectionType.DISCONNECTED));
        }
        this.m_49959_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)worldIn, pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (!tile.canHaveModules()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41720_() instanceof IModule) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)tile.modules, (ItemStack)copy, (boolean)false);
            if (remain.m_41619_()) {
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        } else if (handIn == InteractionHand.MAIN_HAND && stack.m_41619_()) {
            if (!worldIn.f_46443_) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_((Property[])DIRECTIONS.values().toArray(new EnumProperty[0]));
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.createState(worldIn, pos, state);
        if (newState != state) {
            worldIn.m_46597_(pos, newState);
            PipeBlock.onStateChanged(worldIn, pos, newState);
        }
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.createState(context.m_43725_(), context.m_8083_(), this.m_49966_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        PipeBlock.onStateChanged(worldIn, pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.m_60651_(worldIn, pos, context), SHAPE_CACHE, null);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.m_60742_(worldIn, pos, context), COLL_SHAPE_CACHE, s -> {
            MutableObject newShape = new MutableObject((Object)Shapes.m_83040_());
            s.m_83286_((x1, y1, z1, x2, y2, z2) -> newShape.setValue((Object)Shapes.m_83113_((VoxelShape)Shapes.m_166049_((double)x1, (double)y1, (double)z1, (double)x2, (double)(y2 + 0.1875), (double)z2), (VoxelShape)((VoxelShape)newShape.getValue()), (BooleanOp)BooleanOp.f_82695_)));
            return ((VoxelShape)newShape.getValue()).m_83296_();
        });
    }

    private VoxelShape cacheAndGetShape(BlockState state, BlockGetter worldIn, BlockPos pos, Function<BlockState, VoxelShape> coverShapeSelector, Map<Pair<BlockState, BlockState>, VoxelShape> cache, Function<VoxelShape, VoxelShape> shapeModifier) {
        Pair key;
        VoxelShape shape;
        VoxelShape coverShape = null;
        BlockState cover = null;
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, worldIn, pos);
        if (tile != null && tile.cover != null) {
            cover = tile.cover;
            try {
                coverShape = coverShapeSelector.apply(cover);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((shape = cache.get(key = Pair.of((Object)state, cover))) == null) {
            shape = CENTER_SHAPE;
            for (Map.Entry<Direction, EnumProperty<ConnectionType>> entry : DIRECTIONS.entrySet()) {
                if (!((ConnectionType)((Object)state.m_61143_((Property)entry.getValue()))).isConnected()) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DIR_SHAPES.get(entry.getKey()));
            }
            if (shapeModifier != null) {
                shape = shapeModifier.apply(shape);
            }
            if (coverShape != null) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)coverShape);
            }
            cache.put((Pair<BlockState, BlockState>)key, shape);
        }
        return shape;
    }

    private BlockState createState(Level world, BlockPos pos, BlockState curr) {
        BlockState state = this.m_49966_();
        FluidState fluid = world.m_6425_(pos);
        if (fluid.m_76153_((Tag)FluidTags.f_13131_) && fluid.m_76186_() == 8) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        for (Direction dir : Direction.values()) {
            EnumProperty<ConnectionType> prop = DIRECTIONS.get(dir);
            ConnectionType type = this.getConnectionType(world, pos, dir, state);
            if (type.isConnected() && curr.m_61143_(prop) == ConnectionType.BLOCKED) {
                type = ConnectionType.BLOCKED;
            }
            state = (BlockState)state.m_61124_(prop, (Comparable)((Object)type));
        }
        return state;
    }

    protected ConnectionType getConnectionType(Level world, BlockPos pos, Direction direction, BlockState state) {
        IItemHandler blockHandler;
        BlockPos offset = pos.m_142300_(direction);
        if (!world.m_46749_(offset)) {
            return ConnectionType.DISCONNECTED;
        }
        Direction opposite = direction.m_122424_();
        BlockEntity tile = world.m_7702_(offset);
        if (tile != null) {
            IPipeConnectable connectable = (IPipeConnectable)tile.getCapability(Registry.pipeConnectableCapability, opposite).orElse(null);
            if (connectable != null) {
                return connectable.getConnectionType(pos, direction);
            }
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite).orElse(null);
            if (handler != null) {
                return ConnectionType.CONNECTED;
            }
        }
        if ((blockHandler = Utility.getBlockItemHandler(world, offset, opposite)) != null) {
            return ConnectionType.CONNECTED;
        }
        BlockState offState = world.m_8055_(offset);
        if (PipeBlock.hasLegsTo(world, offState, offset, direction) && DIRECTIONS.values().stream().noneMatch(d -> state.m_61143_((Property)d) == ConnectionType.LEGS)) {
            return ConnectionType.LEGS;
        }
        return ConnectionType.DISCONNECTED;
    }

    protected static boolean hasLegsTo(Level world, BlockState state, BlockPos pos, Direction direction) {
        if (state.m_60734_() instanceof WallBlock || state.m_60734_() instanceof FenceBlock) {
            return direction == Direction.DOWN;
        }
        if (state.m_60767_() == Material.f_76278_ || state.m_60767_() == Material.f_76279_) {
            return PipeBlock.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)direction.m_122424_());
        }
        return false;
    }

    public static void onStateChanged(Level world, BlockPos pos, BlockState newState) {
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)world, pos);
        if (tile != null) {
            tile.moduleDropCheck = 5;
        }
        PipeNetwork network = PipeNetwork.get(world);
        int connections = 0;
        boolean force = false;
        for (Direction dir : Direction.values()) {
            ConnectionType value = (ConnectionType)((Object)newState.m_61143_((Property)DIRECTIONS.get(dir)));
            if (!value.isConnected()) continue;
            ++connections;
            BlockState otherState = world.m_8055_(pos.m_142300_(dir));
            if (otherState.m_60734_() == newState.m_60734_()) continue;
            force = true;
            break;
        }
        if (force || connections > 2) {
            network.addNode(pos, newState);
        } else {
            network.removeNode(pos);
        }
        network.onPipeChanged(pos, newState);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            PipeNetwork network = PipeNetwork.get(worldIn);
            network.removeNode(pos);
            network.onPipeChanged(pos, state);
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        PipeBlock.dropItems(worldIn, pos, player);
        super.m_5707_(worldIn, pos, state, player);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        PipeBlockEntity pipe = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)world, pos);
        if (pipe == null) {
            return 0;
        }
        return Math.min(15, pipe.getItems().size());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PipeBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return PipeBlock.m_152132_(type, Registry.pipeBlockEntity, PipeBlockEntity::tick);
    }

    public static void dropItems(Level worldIn, BlockPos pos, Player player) {
        PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)worldIn, pos);
        if (tile != null) {
            Utility.dropInventory(tile, (IItemHandler)tile.modules);
            for (IPipeItem item : tile.getItems()) {
                item.drop(worldIn, item.getContent());
            }
            if (tile.cover != null) {
                tile.removeCover(player, InteractionHand.MAIN_HAND);
            }
        }
    }

    static {
        for (Direction dir : Direction.values()) {
            DIRECTIONS.put(dir, (EnumProperty<ConnectionType>)EnumProperty.m_61587_((String)dir.m_122433_(), ConnectionType.class));
        }
    }
}

