/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class PacketGhostSlot {
    private BlockPos pos;
    private ListMultimap<Integer, ItemStack> stacks;

    public PacketGhostSlot(BlockPos pos, ListMultimap<Integer, ItemStack> stacks) {
        this.pos = pos;
        this.stacks = stacks;
    }

    private PacketGhostSlot() {
    }

    public static PacketGhostSlot fromBytes(FriendlyByteBuf buf) {
        PacketGhostSlot packet = new PacketGhostSlot();
        packet.pos = buf.m_130135_();
        packet.stacks = ArrayListMultimap.create();
        for (int i = buf.readInt(); i > 0; --i) {
            packet.stacks.put((Object)buf.readInt(), (Object)buf.m_130267_());
        }
        return packet;
    }

    public static void toBytes(PacketGhostSlot packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeInt(packet.stacks.size());
        for (Map.Entry entry : packet.stacks.entries()) {
            buf.writeInt(((Integer)entry.getKey()).intValue());
            buf.m_130055_((ItemStack)entry.getValue());
        }
    }

    public static void onMessage(PacketGhostSlot message, Supplier<NetworkEvent.Context> ctx) {
        final Consumer<Player> doIt = p -> {
            CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)p.f_19853_, message.pos);
            if (tile != null) {
                tile.setGhostItems(message.stacks);
            }
        };
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    doIt.accept(Minecraft.m_91087_().f_91074_);
                }
            });
        } else {
            ctx.get().enqueueWork(new Runnable(){
                final /* synthetic */ Player val$player;
                {
                    this.val$player = player;
                }

                @Override
                public void run() {
                    doIt.accept(this.val$player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

