/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui.fast_loading_screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.screen_quad.BasicScreenQuadVertexSink;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LevelLoadingScreen.class})
public class MixinLevelLoadingScreen {
    @Mutable
    @Shadow
    @Final
    private static Object2IntMap<ChunkStatus> f_96140_;
    private static Reference2IntOpenHashMap<ChunkStatus> STATUS_TO_COLOR_FAST;
    private static final int NULL_STATUS_COLOR;
    private static final int DEFAULT_STATUS_COLOR;

    @Overwrite
    public static void m_96149_(PoseStack matrixStack, StoringChunkProgressListener tracker, int mapX, int mapY, int mapScale, int mapPadding) {
        if (STATUS_TO_COLOR_FAST == null) {
            STATUS_TO_COLOR_FAST = new Reference2IntOpenHashMap(f_96140_.size());
            STATUS_TO_COLOR_FAST.put(null, NULL_STATUS_COLOR);
            f_96140_.object2IntEntrySet().forEach(entry -> STATUS_TO_COLOR_FAST.put((Object)((ChunkStatus)entry.getKey()), ColorARGB.toABGR(entry.getIntValue(), 255)));
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        BasicScreenQuadVertexSink sink = VertexDrain.of((VertexConsumer)buffer).createSink(VanillaVertexTypes.BASIC_SCREEN_QUADS);
        int centerSize = tracker.m_9672_();
        int size = tracker.m_9673_();
        int tileSize = mapScale + mapPadding;
        if (mapPadding != 0) {
            int mapRenderCenterSize = centerSize * tileSize - mapPadding;
            int radius = mapRenderCenterSize / 2 + 1;
            sink.ensureCapacity(16);
            MixinLevelLoadingScreen.addRect(matrix, sink, mapX - radius, mapY - radius, mapX - radius + 1, mapY + radius, DEFAULT_STATUS_COLOR);
            MixinLevelLoadingScreen.addRect(matrix, sink, mapX + radius - 1, mapY - radius, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
            MixinLevelLoadingScreen.addRect(matrix, sink, mapX - radius, mapY - radius, mapX + radius, mapY - radius + 1, DEFAULT_STATUS_COLOR);
            MixinLevelLoadingScreen.addRect(matrix, sink, mapX - radius, mapY + radius - 1, mapX + radius, mapY + radius, DEFAULT_STATUS_COLOR);
        }
        int mapRenderSize = size * tileSize - mapPadding;
        int mapStartX = mapX - mapRenderSize / 2;
        int mapStartY = mapY - mapRenderSize / 2;
        ChunkStatus prevStatus = null;
        int prevColor = NULL_STATUS_COLOR;
        sink.ensureCapacity(size * size * 4);
        for (int x = 0; x < size; ++x) {
            int tileX = mapStartX + x * tileSize;
            for (int z = 0; z < size; ++z) {
                int color;
                int tileY = mapStartY + z * tileSize;
                ChunkStatus status = tracker.m_9663_(x, z);
                if (prevStatus == status) {
                    color = prevColor;
                } else {
                    color = STATUS_TO_COLOR_FAST.getInt((Object)status);
                    prevStatus = status;
                    prevColor = color;
                }
                MixinLevelLoadingScreen.addRect(matrix, sink, tileX, tileY, tileX + mapScale, tileY + mapScale, color);
            }
        }
        sink.flush();
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    private static void addRect(Matrix4f matrix, BasicScreenQuadVertexSink sink, int x1, int y1, int x2, int y2, int color) {
        sink.writeQuad(matrix, x1, y2, 0.0f, color);
        sink.writeQuad(matrix, x2, y2, 0.0f, color);
        sink.writeQuad(matrix, x2, y1, 0.0f, color);
        sink.writeQuad(matrix, x1, y1, 0.0f, color);
    }

    static {
        NULL_STATUS_COLOR = ColorABGR.pack(0, 0, 0, 255);
        DEFAULT_STATUS_COLOR = ColorARGB.pack(0, 17, 255, 255);
    }
}

