/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.plugin.jade;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import snownee.fruits.FruitType;
import snownee.fruits.Hooks;
import snownee.fruits.plugin.jade.JadePlugin;
import snownee.kiwi.util.NBTHelper;

public class BeePollenProvider
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    public static final BeePollenProvider INSTANCE = new BeePollenProvider();

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!config.get(JadePlugin.BEE) || !(accessor.getEntity() instanceof Bee)) {
            return;
        }
        CompoundTag data = accessor.getServerData();
        if (!data.m_128441_("pollen")) {
            return;
        }
        ListTag list = data.m_128437_("pollen", 8);
        List<Either<FruitType, Block>> pollen = Hooks.readPollen(list);
        ArrayList elements = Lists.newArrayList();
        IElementHelper helper = tooltip.getElementHelper();
        for (Either<FruitType, Block> e : pollen) {
            ItemStack stack = new ItemStack((ItemLike)e.map(type -> type.fruit, block -> block));
            elements.add(helper.item(stack));
        }
        tooltip.add((List)elements);
    }

    public void appendServerData(CompoundTag tag, ServerPlayer player, Level world, Entity entity, boolean showDetails) {
        NBTHelper data;
        ListTag list;
        if (entity instanceof Bee && (list = (data = NBTHelper.of((CompoundTag)entity.getPersistentData())).getTagList("FruitsList", 8)) != null) {
            tag.m_128365_("pollen", (Tag)list);
        }
    }
}

