/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.food;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;

@KiwiModule(value="food")
@KiwiModule.Optional
@KiwiModule.Category(value="food")
public class FoodModule
extends AbstractModule {
    public static final Item GRAPEFRUIT_PANNA_COTTA = new Item(FoodModule.itemProp().m_41489_(Foods.GRAPEFRUIT_PANNA_COTTA).m_41491_(null));
    public static final Item DONAUWELLE = new Item(FoodModule.itemProp().m_41489_(Foods.DONAUWELLE));
    public static final Item HONEY_POMELO_TEA = new Item(FoodModule.itemProp().m_41489_(Foods.HONEY_POMELO_TEA).m_41495_(Items.f_42590_));
    public static final Item RICE_WITH_FRUITS = new Item(FoodModule.itemProp().m_41489_(Foods.RICE_WITH_FRUITS));
    public static final Item LEMON_ROAST_CHICKEN = new Item(FoodModule.itemProp().m_41489_(Foods.LEMON_ROAST_CHICKEN).m_41495_(Items.f_42399_));

    public static final class Foods {
        private static final Supplier<MobEffectInstance> NOURISHED_PROVIDER = Foods.makeSupplier("farmersdelight:nourished", 6000, 0);
        private static final Supplier<MobEffectInstance> COMFORT_PROVIDER = Foods.makeSupplier("farmersdelight:comfort", 3600, 0);
        private static final Supplier<MobEffectInstance> REGENERATION_PROVIDER = Foods.makeSupplier("regeneration", 120, 0);
        private static final Supplier<MobEffectInstance> SPEED_PROVIDER = Foods.makeSupplier("speed", 1200, 0);
        public static final FoodProperties GRAPEFRUIT_PANNA_COTTA = new FoodProperties.Builder().m_38760_(14).m_38758_(1.0f).effect(SPEED_PROVIDER, 1.0f).m_38767_();
        public static final FoodProperties DONAUWELLE = new FoodProperties.Builder().m_38760_(14).m_38758_(1.0f).effect(REGENERATION_PROVIDER, 1.0f).m_38767_();
        public static final FoodProperties HONEY_POMELO_TEA = new FoodProperties.Builder().m_38760_(1).m_38758_(0.3f).effect(COMFORT_PROVIDER, 1.0f).m_38767_();
        public static final FoodProperties RICE_WITH_FRUITS = new FoodProperties.Builder().m_38760_(9).m_38758_(0.6f).effect(COMFORT_PROVIDER, 1.0f).m_38767_();
        public static final FoodProperties LEMON_ROAST_CHICKEN = new FoodProperties.Builder().m_38760_(12).m_38758_(0.9f).effect(NOURISHED_PROVIDER, 1.0f).m_38767_();

        private static Supplier<MobEffectInstance> makeSupplier(String id, int duration, int amplifier) {
            return Lazy.of(() -> {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(id));
                if (effect == null) {
                    return null;
                }
                return new MobEffectInstance(effect, duration, amplifier);
            });
        }
    }
}

