/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.cherry.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PetalParticle
extends TextureSheetParticle {
    private float angleStepX;
    private float angleStepZ;
    private Vector3f vForce;
    private float rollX;
    private float oRollX;
    private boolean inWater;

    private PetalParticle(ClientLevel world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.f_107225_ = 100;
        this.f_107224_ = this.f_107223_.nextInt(20);
        this.f_107663_ = 0.75f + this.f_107223_.nextFloat() * 0.25f;
        this.f_107230_ = 0.7f + this.f_107223_.nextFloat() * 0.3f;
        float baseMotionX = 0.05f + this.f_107223_.nextFloat() * 0.02f;
        float baseMotionY = -0.1f;
        float baseMotionZ = 0.075f + this.f_107223_.nextFloat() * 0.02f;
        Vector3f motion = new Vector3f(baseMotionX, baseMotionY, baseMotionZ);
        motion.m_122278_();
        this.vForce = new Vector3f(baseMotionZ, 0.0f, -baseMotionX);
        Quaternion rot = this.vForce.m_122240_(-90.0f);
        this.vForce = motion.m_122281_();
        this.vForce.m_122251_(rot);
        motion.m_122261_(0.1f + this.f_107223_.nextFloat() * 0.05f);
        this.f_107215_ = motion.m_122239_();
        this.f_107216_ = motion.m_122260_();
        this.f_107217_ = motion.m_122269_();
        this.angleStepX = 0.1f + this.f_107223_.nextFloat() * 0.1f;
        this.angleStepZ = 0.1f + this.f_107223_.nextFloat() * 0.1f;
    }

    public ParticleRenderType m_7556_() {
        return RenderType.INSTANCE;
    }

    public float m_5902_(float pTicks) {
        if (this.f_107225_ - this.f_107224_ < 10) {
            float f = Mth.m_14031_((float)((float)((double)(((float)(this.f_107225_ - this.f_107224_) - pTicks) / 20.0f) * Math.PI)));
            return Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        this.oRollX = this.rollX;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        boolean lastOnGround = this.f_107218_;
        if (!this.f_107218_ && !this.inWater) {
            float mul = this.f_107224_ % 10 < 5 ? 0.03f : -0.03f;
            this.f_107215_ += (double)(this.vForce.m_122239_() * mul);
            this.f_107216_ += (double)(this.vForce.m_122260_() * mul);
            this.f_107217_ += (double)(this.vForce.m_122269_() * mul);
            this.f_107231_ += this.angleStepZ;
            this.rollX += this.angleStepX;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107218_) {
            if (this.f_107218_ && !lastOnGround) {
                this.f_107224_ = this.f_107225_ - 20;
            }
            this.f_107215_ *= 0.5;
            this.f_107217_ *= 0.5;
        } else if (this.inWater) {
            this.f_107215_ *= 0.66;
            this.f_107217_ *= 0.66;
        } else {
            if (lastOnGround) {
                this.f_107224_ = this.f_107225_ - 60;
            }
            this.f_107215_ *= 1.001;
            this.f_107216_ *= 0.998;
            this.f_107217_ *= 1.001;
        }
    }

    public void m_6257_(double pX, double pY, double pZ) {
        int ix = (int)this.f_107212_;
        int iy = (int)this.f_107213_;
        int iz = (int)this.f_107214_;
        BlockPos pos = new BlockPos(ix, iy, iz);
        LevelChunk chunk = this.f_107208_.m_6325_(ix >> 4, iz >> 4);
        FluidState fluidState = chunk.m_62814_(ix, iy, iz);
        float height = fluidState.m_76155_((BlockGetter)this.f_107208_, pos);
        if (fluidState.m_76153_((Tag)FluidTags.f_13131_)) {
            if (!this.inWater && this.f_107213_ <= (double)(height + (float)iy)) {
                this.inWater = true;
                this.f_107224_ -= 60;
                this.f_107216_ = 0.0;
                this.f_107210_ = this.f_107213_ = (double)(height + (float)iy);
            }
            if (this.inWater) {
                Vec3 flow = fluidState.m_76179_((BlockGetter)this.f_107208_, pos);
                this.f_107215_ += flow.f_82479_ * 0.02;
                this.f_107217_ += flow.f_82481_ * 0.02;
                pX = this.f_107215_;
                pZ = this.f_107217_;
            }
        } else if (this.inWater) {
            // empty if block
        }
        double lastX = pX;
        double lastY = pY;
        double lastZ = pZ;
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            Vec3 moveVec = Entity.m_198894_((Entity)null, (Vec3)new Vec3(pX, pY, pZ), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            pX = moveVec.f_82479_;
            pY = moveVec.f_82480_;
            pZ = moveVec.f_82481_;
        }
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            if (this.inWater) {
                double targetY = height + (float)iy;
                pY = Mth.m_14008_((double)(targetY - this.f_107213_), (double)-0.005, (double)0.02);
            }
            this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
            this.m_107275_();
        }
        if (Math.abs(lastY) >= (double)1.0E-5f && Math.abs(pY) < (double)1.0E-5f) {
            this.f_107205_ = true;
        }
        if (!this.inWater) {
            boolean bl = this.f_107218_ = lastY != pY && lastY < 0.0;
        }
        if (lastX != pX) {
            this.f_107215_ = 0.0;
        }
        if (lastZ != pZ) {
            this.f_107217_ = 0.0;
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 vec3d = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        Quaternion quaternion = new Quaternion(renderInfo.m_90591_());
        float rx = Mth.m_14179_((float)partialTicks, (float)this.oRollX, (float)this.rollX);
        float rz = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
        if (this.f_107218_ || this.inWater) {
            quaternion = Vector3f.f_122223_.m_122240_(90.0f);
            f1 = this.inWater ? (float)((double)f1 + ((double)0.16f + (double)rz % 0.01)) : (float)((double)f1 + ((double)0.005f + (double)rz % 0.01));
        } else {
            quaternion = new Quaternion(renderInfo.m_90591_());
            quaternion.m_80148_(Vector3f.f_122223_.m_122270_(rx));
        }
        quaternion.m_80148_(Vector3f.f_122227_.m_122270_(rz));
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.m_122251_(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(partialTicks);
        float alpha = f4 * this.f_107230_;
        f4 *= this.f_107663_ * 0.15f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(f4);
            vector3f.m_122272_(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        buffer.m_5483_((double)avector3f[0].m_122239_(), (double)avector3f[0].m_122260_(), (double)avector3f[0].m_122269_()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].m_122239_(), (double)avector3f[1].m_122260_(), (double)avector3f[1].m_122269_()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].m_122239_(), (double)avector3f[2].m_122260_(), (double)avector3f[2].m_122269_()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].m_122239_(), (double)avector3f[3].m_122260_(), (double)avector3f[3].m_122269_()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
    }

    public static enum RenderType implements ParticleRenderType
    {
        INSTANCE;


        public void m_6505_(BufferBuilder pBuilder, TextureManager pTextureManager) {
            RenderSystem.m_69464_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            pBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator pTesselator) {
            pTesselator.m_85914_();
            RenderSystem.m_69481_();
        }

        public String toString() {
            return "PARTICLE_SHEET_TRANSLUCENT_NO_CULL";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PetalParticle noteparticle = new PetalParticle(worldIn, x, y, z);
            noteparticle.m_108335_(this.spriteSet);
            return noteparticle;
        }
    }
}

