/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.cherry;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import snownee.fruits.FruitType;
import snownee.fruits.FruitsMod;
import snownee.fruits.Hooks;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.block.grower.FruitTreeGrower;
import snownee.fruits.cherry.FruitTypeExtension;
import snownee.fruits.cherry.block.CherryLeavesBlock;
import snownee.fruits.cherry.block.SlidingDoorBlock;
import snownee.fruits.cherry.client.particle.PetalParticle;
import snownee.fruits.cherry.datagen.CherryBlockLoot;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.data.provider.KiwiLootTableProvider;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.VanillaActions;

@KiwiModule(value="cherry")
@KiwiModule.Optional
@KiwiModule.Subscriber(value=KiwiModule.Subscriber.Bus.MOD)
public class CherryModule
extends AbstractModule {
    @KiwiModule.Category(value="building_blocks")
    public static RotatedPillarBlock CHERRY_LOG = new RotatedPillarBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_49999_));
    @KiwiModule.Category(value="building_blocks")
    public static Block CHERRY_WOOD = new RotatedPillarBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50014_));
    @KiwiModule.Category(value="building_blocks")
    public static Block STRIPPED_CHERRY_LOG = new RotatedPillarBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50007_));
    @KiwiModule.Category(value="building_blocks")
    public static Block STRIPPED_CHERRY_WOOD = new RotatedPillarBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50047_));
    @KiwiModule.Category(value="building_blocks")
    public static Block CHERRY_PLANKS = new ModBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50743_));
    @KiwiModule.Category(value="building_blocks")
    public static SlabBlock CHERRY_SLAB = new SlabBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50401_));
    @KiwiModule.Category(value="building_blocks")
    public static StairBlock CHERRY_STAIRS = new StairBlock(() -> CHERRY_PLANKS.m_49966_(), CherryModule.blockProp((BlockBehaviour)Blocks.f_50271_));
    @KiwiModule.Category(value="decorations")
    public static FenceBlock CHERRY_FENCE = new FenceBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50481_));
    @KiwiModule.Category(value="redstone")
    public static FenceGateBlock CHERRY_FENCE_GATE = new FenceGateBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50476_));
    @KiwiModule.Category(value="redstone")
    public static TrapDoorBlock CHERRY_TRAPDOOR = new TrapDoorBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50219_));
    @KiwiModule.Category(value="redstone")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static DoorBlock CHERRY_DOOR = new DoorBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50486_));
    @KiwiModule.Category(value="redstone")
    public static SlidingDoorBlock CHERRY_SLIDING_DOOR = new SlidingDoorBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50486_));
    @KiwiModule.Category(value="redstone")
    public static WoodButtonBlock CHERRY_BUTTON = new WoodButtonBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50219_));
    @KiwiModule.Category(value="redstone")
    public static PressurePlateBlock CHERRY_PRESSURE_PLATE = new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, CherryModule.blockProp((BlockBehaviour)Blocks.f_50486_));
    public static final SimpleParticleType PETAL_CHERRY = new SimpleParticleType(false);
    public static final SimpleParticleType PETAL_REDLOVE = new SimpleParticleType(false);
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static LeavesBlock CHERRY_LEAVES = new CherryLeavesBlock(() -> FruitTypeExtension.CHERRY, CherryModule.blockProp((BlockBehaviour)Blocks.f_50050_).m_155949_(MaterialColor.f_76418_), (ParticleOptions)PETAL_CHERRY);
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static LeavesBlock REDLOVE_LEAVES = new CherryLeavesBlock(() -> FruitTypeExtension.REDLOVE, CherryModule.blockProp((BlockBehaviour)Blocks.f_50050_).m_155949_(MaterialColor.f_76389_), (ParticleOptions)PETAL_REDLOVE);
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static CarpetBlock CHERRY_CARPET = new CarpetBlock(CherryModule.blockProp((BlockBehaviour)CHERRY_LEAVES));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static CarpetBlock REDLOVE_CARPET = new CarpetBlock(CherryModule.blockProp((BlockBehaviour)REDLOVE_LEAVES));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock CHERRY_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitTypeExtension.CHERRY), CherryModule.blockProp((BlockBehaviour)Blocks.f_50746_).m_155949_(MaterialColor.f_76418_));
    @KiwiModule.Category(value="decorations")
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static SaplingBlock REDLOVE_SAPLING = new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower(() -> FruitTypeExtension.REDLOVE), CherryModule.blockProp((BlockBehaviour)Blocks.f_50746_).m_155949_(MaterialColor.f_76389_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_CHERRY = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> CHERRY_SAPLING, CherryModule.blockProp((BlockBehaviour)Blocks.f_50277_));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static FlowerPotBlock POTTED_REDLOVE = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> REDLOVE_SAPLING, CherryModule.blockProp((BlockBehaviour)Blocks.f_50277_));
    @KiwiModule.Category(value="food")
    public static Item CHERRY = new ModItem(CherryModule.itemProp().m_41489_(Foods.CHERRY));
    @KiwiModule.Category(value="food")
    public static Item REDLOVE = new ModItem(CherryModule.itemProp().m_41489_(Foods.REDLOVE));
    public static final BannerPattern HEART = BannerPattern.create((String)"HEART", (String)"heart", (String)"hrt", (boolean)true);
    @KiwiModule.Category(value="misc")
    public static final BannerPatternItem HEART_BANNER_PATTERN = new BannerPatternItem(HEART, CherryModule.itemProp().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    public static final WoodType CHERRY_WOODTYPE = WoodType.create((String)"fruittrees_cherry");
    @KiwiModule.NoItem
    public static StandingSignBlock CHERRY_SIGN = new StandingSignBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50152_), CHERRY_WOODTYPE);
    @KiwiModule.NoItem
    public static WallSignBlock CHERRY_WALL_SIGN = new WallSignBlock(CherryModule.blockProp((BlockBehaviour)Blocks.f_50162_), CHERRY_WOODTYPE);
    @KiwiModule.Name(value="cherry_sign")
    @KiwiModule.Category(value="decorations")
    public static SignItem CHERRY_SIGN_ITEM = new SignItem(CherryModule.itemProp().m_41487_(16), (Block)CHERRY_SIGN, (Block)CHERRY_WALL_SIGN);

    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.f_50276_;
            pot.addPlant(CHERRY_SAPLING.getRegistryName(), () -> POTTED_CHERRY);
            pot.addPlant(REDLOVE_SAPLING.getRegistryName(), () -> POTTED_REDLOVE);
            VanillaActions.registerAxeConversion((Block)CHERRY_LOG, (Block)STRIPPED_CHERRY_LOG);
            VanillaActions.registerAxeConversion((Block)CHERRY_WOOD, (Block)STRIPPED_CHERRY_WOOD);
            VanillaActions.registerCompostable((float)0.1f, (ItemLike)CHERRY_CARPET);
            VanillaActions.registerCompostable((float)0.1f, (ItemLike)REDLOVE_CARPET);
            WoodType.m_61844_((WoodType)CHERRY_WOODTYPE);
        }).whenComplete((v, ex) -> {
            if (ex != null) {
                FruitsMod.logger.catching(ex);
            }
        });
    }

    public CherryModule() {
        Hooks.cherry = true;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit(ModelRegistryEvent event) {
        Sheets.addWoodType((WoodType)CHERRY_WOODTYPE);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new KiwiLootTableProvider(generator).add(CherryBlockLoot::new, LootContextParamSets.f_81421_));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    protected void clientInit(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)PETAL_CHERRY, PetalParticle.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)PETAL_REDLOVE, PetalParticle.Factory::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void handleBlockColor(ColorHandlerEvent.Block event) {
        BlockState birchLeaves = Blocks.f_50052_.m_49966_();
        BlockColors blockColors = event.getBlockColors();
        blockColors.m_92589_((state, world, pos, i) -> {
            if (i == 0) {
                return blockColors.m_92577_(birchLeaves, world, pos, i);
            }
            if (i == 1) {
                int stage = (Integer)state.m_61143_((Property)FruitLeavesBlock.AGE);
                if (stage < 3) {
                    return blockColors.m_92577_(birchLeaves, world, pos, i);
                }
                Block block = state.m_60734_();
                if (block == REDLOVE_LEAVES) {
                    return 0xC22626;
                }
                if (block == CHERRY_LEAVES) {
                    return 14965589;
                }
            }
            return -1;
        }, new Block[]{CHERRY_LEAVES, REDLOVE_LEAVES});
    }

    static {
        FruitTypeExtension.CHERRY = FruitType.create("CHERRY", 0, (Block)CHERRY_LOG, CHERRY_LEAVES, () -> CHERRY_SAPLING, CHERRY, (Block)CHERRY_CARPET);
        FruitTypeExtension.REDLOVE = FruitType.create("REDLOVE", 2, (Block)CHERRY_LOG, REDLOVE_LEAVES, () -> REDLOVE_SAPLING, REDLOVE, (Block)REDLOVE_CARPET);
    }

    public static final class Foods {
        public static final FoodProperties CHERRY = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38767_();
        public static final FoodProperties REDLOVE = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance(MobEffects.f_19605_, 50), 1.0f).m_38767_();
    }
}

