/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import snownee.fruits.CoreModule;
import snownee.fruits.FruitType;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.kiwi.block.entity.BaseBlockEntity;
import snownee.kiwi.util.NBTHelper;

public class FruitTreeBlockEntity
extends BaseBlockEntity
implements GameEventListener {
    public FruitType f_58855_ = FruitType.CITRON;
    private int deathRate = 0;
    private ItemEntity onlyItem;
    private PositionSource source;

    public FruitTreeBlockEntity(BlockPos pos, BlockState state) {
        super(CoreModule.FRUIT_TREE, pos, state);
        this.source = new BlockPositionSource(pos);
    }

    public FruitTreeBlockEntity(BlockPos pos, BlockState state, FruitType type) {
        this(pos, state);
        this.f_58855_ = type;
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return null;
    }

    protected void readPacketData(CompoundTag data) {
    }

    protected CompoundTag writePacketData(CompoundTag data) {
        return data;
    }

    public void m_142466_(CompoundTag compound) {
        NBTHelper helper = NBTHelper.of((CompoundTag)compound);
        String id = helper.getString("type");
        if (id != null) {
            this.f_58855_ = FruitType.parse(id);
            if (this.f_58855_ == null) {
                this.f_58855_ = FruitType.CITRON;
            }
        } else {
            FruitType[] types = FruitType.values();
            this.f_58855_ = types[Mth.m_14045_((int)helper.getInt("type"), (int)0, (int)types.length)];
        }
        this.deathRate = helper.getInt("death");
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128359_("type", this.f_58855_.name());
        compound.m_128405_("death", this.deathRate);
        super.m_183515_(compound);
    }

    public boolean canDrop() {
        return this.onlyItem == null || !this.onlyItem.m_6084_();
    }

    public void setOnlyItem(ItemEntity itementity) {
        this.onlyItem = itementity;
    }

    public PositionSource m_142460_() {
        return this.source;
    }

    public int m_142078_() {
        return 6;
    }

    public float getDeathRate() {
        if (this.deathRate <= 10) {
            return 0.0f;
        }
        if (this.deathRate >= 50) {
            return 1.0f;
        }
        return (float)this.deathRate / 50.0f;
    }

    public boolean m_142721_(Level level, GameEvent gameEvent, Entity entity, BlockPos pos) {
        if (CoreModule.FRUIT_DROP.matches(gameEvent)) {
            if (this.canDrop()) {
                BlockState state = level.m_8055_(pos);
                ++this.deathRate;
                CoreModule.FRUIT_DROP.runnable = FruitLeavesBlock.dropFruit(level, pos, state, this.getDeathRate());
            }
            CoreModule.FRUIT_DROP.swallow(this);
            return true;
        }
        if (CoreModule.LEAVES_TRAMPLE.matches(gameEvent)) {
            this.deathRate += 3;
            CoreModule.LEAVES_TRAMPLE.swallow(this);
            return true;
        }
        return false;
    }
}

