/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.KiwiClientConfig;

public class ModItem
extends Item {
    public ModItem(Item.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!KiwiClientConfig.globalTooltip) {
            ModItem.addTip(stack, tooltip, flagIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addTip(ItemStack stack, List<Component> tooltip, TooltipFlag flagIn) {
        boolean ctrl;
        if (tooltip.isEmpty()) {
            return;
        }
        boolean shift = Screen.m_96638_();
        String key = shift == (ctrl = Screen.m_96637_()) ? stack.m_41778_() + ".tip" : (shift ? stack.m_41778_() + ".tip.shift" : stack.m_41778_() + ".tip.ctrl");
        boolean hasKey = I18n.m_118936_((String)key);
        if (!hasKey && shift != ctrl) {
            return;
        }
        if (hasKey) {
            ArrayList lines = Lists.newArrayList((Object[])I18n.m_118938_((String)key, (Object[])new Object[0]).split("\n"));
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int width = Math.max(fontRenderer.m_92895_(tooltip.get(0).getString()), KiwiClientConfig.tooltipWrapWidth);
            tooltip.addAll(lines.stream().map(s -> fontRenderer.m_92865_().m_92432_(s, width, Style.f_131099_)).flatMap(Collection::stream).map(FormattedText::getString).map(TextComponent::new).peek(c -> c.m_130940_(ChatFormatting.GRAY)).collect(Collectors.toList()));
        }
        if (shift == ctrl) {
            boolean hasShiftKey = I18n.m_118936_((String)(key + ".shift"));
            boolean hasCtrlKey = I18n.m_118936_((String)(key + ".ctrl"));
            if (hasShiftKey && hasCtrlKey) {
                tooltip.add((Component)new TranslatableComponent("tip.kiwi.press_shift_or_ctrl"));
            } else if (hasShiftKey) {
                tooltip.add((Component)new TranslatableComponent("tip.kiwi.press_shift"));
            } else if (hasCtrlKey) {
                tooltip.add((Component)new TranslatableComponent("tip.kiwi.press_ctrl"));
            }
        }
    }
}

