/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.integration.jei.resource.DecompositionDummy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DecompositionRecipeCategory
implements IRecipeCategory<DecompositionDummy> {
    public static final ResourceLocation UID = new ResourceLocation("farmersdelight", "decomposition");
    private static final int slotSize = 22;
    private final Component title = TextUtils.getTranslation("jei.decomposition", new Object[0]);
    private final IDrawable background;
    private final IDrawable slotIcon;
    private final IDrawable icon;
    private final ItemStack organicCompost;
    private final ItemStack richSoil;

    public DecompositionRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("farmersdelight", "textures/gui/jei/decomposition.png");
        this.background = helper.createDrawable(backgroundImage, 0, 0, 118, 80);
        this.organicCompost = new ItemStack((ItemLike)ModBlocks.ORGANIC_COMPOST.get());
        this.richSoil = new ItemStack((ItemLike)ModItems.RICH_SOIL.get());
        this.icon = helper.createDrawableIngredient((Object)this.richSoil);
        this.slotIcon = helper.createDrawable(backgroundImage, 119, 0, 22, 22);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends DecompositionDummy> getRecipeClass() {
        return DecompositionDummy.class;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(DecompositionDummy decompositionRecipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)ImmutableList.of((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.organicCompost})));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.richSoil);
    }

    public void setRecipe(IRecipeLayout recipeLayout, DecompositionDummy decompositionRecipe, IIngredients iIngredients) {
        List accelerators = ModTags.COMPOST_ACTIVATORS.m_6497_().stream().map(ItemStack::new).collect(Collectors.toList());
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 8, 25);
        itemStacks.set(0, this.organicCompost);
        itemStacks.init(1, false, 92, 25);
        itemStacks.set(1, this.richSoil);
        itemStacks.init(2, false, 63, 53);
        itemStacks.set(2, accelerators);
    }

    public void draw(DecompositionDummy recipe, PoseStack ms, double mouseX, double mouseY) {
        this.slotIcon.draw(ms, 63, 53);
    }

    public List<Component> getTooltipStrings(DecompositionDummy recipe, double mouseX, double mouseY) {
        if (DecompositionRecipeCategory.inIconAt(40, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)DecompositionRecipeCategory.translateKey(".light"));
        }
        if (DecompositionRecipeCategory.inIconAt(53, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)DecompositionRecipeCategory.translateKey(".fluid"));
        }
        if (DecompositionRecipeCategory.inIconAt(67, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)DecompositionRecipeCategory.translateKey(".accelerators"));
        }
        return Collections.emptyList();
    }

    private static boolean inIconAt(int iconX, int iconY, double mouseX, double mouseY) {
        int icon_size = 11;
        return (double)iconX <= mouseX && mouseX < (double)(iconX + 11) && (double)iconY <= mouseY && mouseY < (double)(iconY + 11);
    }

    private static TranslatableComponent translateKey(@Nonnull String suffix) {
        return new TranslatableComponent("farmersdelight.jei.decomposition" + suffix);
    }
}

