/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.recipes.RecipeCategoryData;
import net.minecraft.resources.ResourceLocation;

public class RecipeCategoryDataMap {
    private final ImmutableMap<ResourceLocation, RecipeCategoryData<?>> map;

    public RecipeCategoryDataMap(List<IRecipeCategory<?>> recipeCategories, ImmutableListMultimap<IRecipeCategory<?>, ITypedIngredient<?>> recipeCategoryCatalystsMap) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (IRecipeCategory<?> recipeCategory : recipeCategories) {
            ImmutableList recipeCategoryCatalysts = recipeCategoryCatalystsMap.get(recipeCategory);
            mapBuilder.put((Object)recipeCategory.getUid(), new RecipeCategoryData(recipeCategory, recipeCategoryCatalysts));
        }
        this.map = mapBuilder.build();
    }

    public <T> RecipeCategoryData<T> get(IRecipeCategory<T> recipeCategory) {
        ResourceLocation recipeCategoryUid = recipeCategory.getUid();
        RecipeCategoryData<?> recipeCategoryData = this.get(recipeCategoryUid);
        return recipeCategoryData;
    }

    public <T> RecipeCategoryData<T> get(Iterable<T> recipes, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<?> recipeCategoryData = this.get(recipeCategoryUid);
        IRecipeCategory<?> recipeCategory = recipeCategoryData.getRecipeCategory();
        Class<?> recipeClass = recipeCategory.getRecipeClass();
        for (T recipe : recipes) {
            if (recipeClass.isInstance(recipe)) continue;
            throw new IllegalArgumentException(recipeCategory.getUid() + " recipes must be an instance of " + recipeClass + ". Instead got: " + recipe.getClass());
        }
        RecipeCategoryData<?> castRecipeCategoryData = recipeCategoryData;
        return castRecipeCategoryData;
    }

    public <T> RecipeCategoryData<T> get(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<?> recipeCategoryData = this.get(recipeCategoryUid);
        IRecipeCategory<?> recipeCategory = recipeCategoryData.getRecipeCategory();
        Class<?> recipeClass = recipeCategory.getRecipeClass();
        if (!recipeClass.isInstance(recipe)) {
            throw new IllegalArgumentException(recipeCategory.getUid() + " recipes must be an instance of " + recipeClass + ". Instead got: " + recipe.getClass());
        }
        RecipeCategoryData<?> castRecipeCategoryData = recipeCategoryData;
        return castRecipeCategoryData;
    }

    public RecipeCategoryData<?> get(ResourceLocation recipeCategoryUid) {
        RecipeCategoryData recipeCategoryData = (RecipeCategoryData)this.map.get((Object)recipeCategoryUid);
        if (recipeCategoryData == null) {
            throw new IllegalStateException("There is no recipe category registered for: " + recipeCategoryUid);
        }
        return recipeCategoryData;
    }

    public void validate(ResourceLocation recipeCategoryUid) {
        if (!this.map.containsKey((Object)recipeCategoryUid)) {
            throw new IllegalStateException("There is no recipe category registered for: " + recipeCategoryUid);
        }
    }
}

