/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.cooking.fuel;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.config.Constants;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.vanilla.cooking.FurnaceVariantCategory;
import mezz.jei.plugins.vanilla.cooking.fuel.FuelRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class FurnaceFuelCategory
extends FurnaceVariantCategory<FuelRecipe> {
    private final IDrawableStatic background;
    private final IDrawableStatic flameTransparentBackground;
    private final Component localizedName;

    public FurnaceFuelCategory(IGuiHelper guiHelper, Textures textures) {
        super(guiHelper);
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        Component smeltCountText = FuelRecipe.createSmeltCountText(100000);
        int stringWidth = fontRenderer.m_92895_(smeltCountText.getString());
        this.background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 134, 18, 34).addPadding(0, 0, 0, stringWidth + 20).build();
        this.flameTransparentBackground = textures.getFlameIcon();
        this.localizedName = new TranslatableComponent("gui.jei.category.fuel");
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaRecipeCategoryUid.FUEL;
    }

    @Override
    public Class<? extends FuelRecipe> getRecipeClass() {
        return FuelRecipe.class;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.flameTransparentBackground;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, FuelRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addItemStacks(recipe.getInputs());
    }

    @Override
    public void draw(FuelRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        IDrawableAnimated flame = recipe.getFlame();
        flame.draw(poseStack, 1, 0);
        Minecraft minecraft = Minecraft.m_91087_();
        Component smeltCountText = recipe.getSmeltCountText();
        minecraft.f_91062_.m_92889_(poseStack, smeltCountText, 24.0f, 13.0f, -8355712);
    }
}

