/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.input.TextHistory;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.TextFieldInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.TextComponent;

public class GuiTextFieldFilter
extends EditBox {
    private static final int maxSearchLength = 128;
    private static final TextHistory history = new TextHistory();
    private final HoverChecker hoverChecker;
    private final IIngredientGridSource ingredientSource;
    private final DrawableNineSliceTexture background;
    private boolean previousKeyboardRepeatEnabled;
    private boolean isDrawing = false;

    public GuiTextFieldFilter(IIngredientGridSource ingredientSource) {
        super(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0, TextComponent.f_131282_);
        this.m_94199_(128);
        this.hoverChecker = new HoverChecker();
        this.ingredientSource = ingredientSource;
        this.background = Internal.getTextures().getSearchBackground();
    }

    public void updateBounds(Rect2i area) {
        this.f_93620_ = area.m_110085_();
        this.f_93621_ = area.m_110086_();
        this.f_93618_ = area.m_110090_();
        this.f_93619_ = area.m_110091_();
        this.hoverChecker.updateBounds(area.m_110086_(), area.m_110086_() + area.m_110091_(), area.m_110085_(), area.m_110085_() + area.m_110090_());
        this.m_94208_(this.m_94207_());
    }

    public void m_94144_(String filterText) {
        List<ITypedIngredient<?>> ingredientList;
        if (!filterText.equals(this.m_94155_())) {
            super.m_94144_(filterText);
        }
        if ((ingredientList = this.ingredientSource.getIngredientList(filterText)).size() == 0) {
            this.m_94202_(-65536);
        } else {
            this.m_94202_(-1);
        }
    }

    public Optional<String> getHistory(TextHistory.Direction direction) {
        String currentText = this.m_94155_();
        return history.get(direction, currentText);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new TextFieldInputHandler(this);
    }

    public void m_93692_(boolean keyboardFocus) {
        boolean previousFocus = this.m_93696_();
        super.m_93692_(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (keyboardFocus) {
                this.previousKeyboardRepeatEnabled = minecraft.f_91068_.f_90868_;
                minecraft.f_91068_.m_90926_(true);
            } else {
                minecraft.f_91068_.m_90926_(this.previousKeyboardRepeatEnabled);
            }
            String text = this.m_94155_();
            history.add(text);
        }
    }

    protected boolean m_94219_() {
        if (this.isDrawing) {
            return false;
        }
        return super.m_94219_();
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.isDrawing = true;
        if (this.m_94213_()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(poseStack, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_);
        }
        super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
        this.isDrawing = false;
    }
}

