/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import mezz.jei.network.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public final class ServerInfo {
    @Nullable
    private static UUID jeiOnServerCacheUuid = null;
    private static boolean jeiOnServerCacheValue = false;
    private static final Path worldDirPath = Path.of("world", new String[0]);
    private static final String unsafeFileChars = "[^\\w-]";

    private ServerInfo() {
    }

    public static boolean isJeiOnServer() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        if (clientPacketListener == null) {
            return false;
        }
        UUID id = clientPacketListener.m_105150_();
        if (!id.equals(jeiOnServerCacheUuid)) {
            jeiOnServerCacheUuid = id;
            jeiOnServerCacheValue = Optional.of(clientPacketListener).map(ClientPacketListener::m_6198_).map(NetworkHooks::getConnectionData).map(ConnectionData::getChannels).map(ImmutableMap::keySet).map(keys -> keys.contains((Object)PacketHandler.CHANNEL_ID)).orElse(false);
        }
        return jeiOnServerCacheValue;
    }

    @Nullable
    public static Path getWorldPath(Path basePath) {
        Path worldPath = ServerInfo.getWorldPath();
        if (worldPath == null) {
            return null;
        }
        return basePath.resolve(worldPath);
    }

    @Nullable
    private static Path getWorldPath() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        if (clientPacketListener == null) {
            return null;
        }
        Connection connection = clientPacketListener.m_6198_();
        if (connection.m_129531_()) {
            MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
            if (minecraftServer != null) {
                String name = minecraftServer.f_129744_.m_78277_();
                name = ServerInfo.sanitizePathName(name);
                return worldDirPath.resolve("local").resolve(name);
            }
        } else {
            ServerData serverData = minecraft.m_91089_();
            if (serverData != null) {
                int ipHash = serverData.f_105363_.hashCode();
                String ipHashHex = Integer.toHexString(ipHash);
                String name = String.format("%s_%s", serverData.f_105362_, ipHashHex);
                name = ServerInfo.sanitizePathName(name);
                return worldDirPath.resolve("server").resolve(name);
            }
        }
        return null;
    }

    public static String sanitizePathName(String filename) {
        return String.join((CharSequence)"_", filename.split(unsafeFileChars));
    }
}

