/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="tetrapak")
public class ToolHelper {
    private static final Map<Pair<String, Integer>, List<ItemStack>> tools = new HashMap<Pair<String, Integer>, List<ItemStack>>();
    private static final List<Pair<String, String>> materialPairs = Arrays.asList(Pair.of("oak", "stick"), Pair.of("stone", "stick"), Pair.of("iron", "spruce"), Pair.of("blackstone", "spruce"), Pair.of("obsidian", "iron"), Pair.of("netherite", "forged_beam"));
    private static final List<String> doubleSchematics = Arrays.asList("basic_hammer", "claw");

    private ToolHelper() {
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        tools.clear();
        ToolHelper.populate();
    }

    public static void populate() {
        for (ToolAction t : ToolAction.getActions()) {
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack test = new ItemStack((ItemLike)item);
                for (int i = 0; i <= ToolHelper.getTierOf(test, t); ++i) {
                    tools.computeIfAbsent(Pair.of(t.name(), i), p -> new ArrayList()).add(test);
                }
            }
        }
        materialPairs.forEach(materials -> {
            doubleSchematics.stream().map(schematic -> ToolHelper.setUpDouble(schematic, (String)materials.getFirst(), (String)materials.getSecond())).forEach(ToolHelper::addModular);
            ToolHelper.addModular(ToolHelper.setUpShortBlade((String)materials.getFirst(), (String)materials.getSecond()));
        });
    }

    private static void addModular(ItemStack tool) {
        Item item = tool.m_41720_();
        if (!(item instanceof ItemModularHandheld)) {
            return;
        }
        ItemModularHandheld item2 = (ItemModularHandheld)item;
        ToolAction.getActions().stream().filter(arg_0 -> ((ItemStack)tool).canPerformAction(arg_0)).forEach(t -> {
            for (int i = 0; i <= item2.getHarvestTier(tool, t); ++i) {
                tools.computeIfAbsent(Pair.of(t.name(), i), p -> new ArrayList()).add(tool);
            }
        });
    }

    public static List<ItemStack> getToolsOf(ToolAction type, int level) {
        if (tools.isEmpty()) {
            ToolHelper.populate();
        }
        return tools.getOrDefault(Pair.of(type.name(), level), Collections.emptyList());
    }

    private static ItemStack setUpDouble(String moduleVariant, String headMaterial, String handleMaterial) {
        Item modularDouble = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:modular_double"));
        if (modularDouble == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)modularDouble);
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/head_left", (String)("double/" + moduleVariant + "_left"), (String)("double/" + moduleVariant + "_left_material"), (String)(moduleVariant + "/" + headMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/head_right", (String)("double/" + moduleVariant + "_right"), (String)("double/" + moduleVariant + "_right_material"), (String)(moduleVariant + "/" + headMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/handle", (String)"double/basic_handle", (String)"double/basic_handle_material", (String)("basic_handle/" + handleMaterial));
        IModularItem.updateIdentifier((ItemStack)itemStack);
        return itemStack;
    }

    private static ItemStack setUpShortBlade(String bladeMaterial, String handleMaterial) {
        Item modularSword = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:modular_sword"));
        if (modularSword == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)modularSword);
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"sword/guard", (String)"sword/makeshift_guard", (String)"sword/makeshift_guard_material", (String)"makeshift_guard/oak");
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"sword/pommel", (String)"sword/decorative_pommel", (String)"sword/decorative_pommel_material", (String)"decorative_pommel/oak");
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"sword/hilt", (String)"sword/basic_hilt", (String)"sword/basic_hilt_material", (String)("basic_hilt/" + handleMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"sword/blade", (String)"sword/short_blade", (String)"sword/short_blade_material", (String)("short_blade/" + bladeMaterial));
        IModularItem.updateIdentifier((ItemStack)itemStack);
        return itemStack;
    }

    public static int getTierOf(@Nullable ItemStack stack, ToolAction action) {
        if (stack == null || stack.m_41619_()) {
            return -1;
        }
        Item item = stack.m_41720_();
        if (item instanceof ItemModularHandheld) {
            ItemModularHandheld handheld = (ItemModularHandheld)item;
            return handheld.getHarvestTier(stack, action);
        }
        item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return tieredItem.m_43314_().m_6604_();
        }
        return -1;
    }
}

