/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.TetraPak;
import mod.noobulus.tetrapak.mixin.accessor.LootPoolAccessor;
import mod.noobulus.tetrapak.mixin.accessor.LootTableAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="tetrapak")
public class LootLoader {
    private static final int STATISTICAL_TEST = 100;
    @Nullable
    private static MinecraftServer server = null;
    private static LootTables manager;

    private LootLoader() {
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        server = event.getServer();
    }

    @Nullable
    private static MinecraftServer getServer() {
        if (server == null) {
            return (MinecraftServer)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().m_91092_(), () -> () -> null);
        }
        return server;
    }

    public static LootTables getManager() {
        MinecraftServer server = LootLoader.getServer();
        if (server == null) {
            if (manager == null) {
                manager = new LootTables(new PredicateManager());
                TetraPak.LOGGER.error("Loot tables should never be calculated on the client!");
            }
            return manager;
        }
        return server.m_129898_();
    }

    public static List<LootSlot> crawlTable(LootTable table, LootTables manager) {
        LootContext dummyContext = new LootContext.Builder(LootLoader.getServer().m_129783_()).m_78975_(new LootContextParamSet.Builder().m_81405_());
        ArrayList<LootSlot> drops = new ArrayList<LootSlot>();
        LootLoader.getPools(table).forEach(pool -> {
            int min = LootLoader.getMin(pool.getRolls(), dummyContext);
            int max = LootLoader.getMax(pool.getRolls(), dummyContext) + LootLoader.getMax(pool.getBonusRolls(), dummyContext);
            float totalWeight = LootLoader.getLootEntries(pool).stream().filter(LootPoolSingletonContainer.class::isInstance).map(LootPoolSingletonContainer.class::cast).mapToInt(entry -> entry.f_79675_).sum();
            LootLoader.getLootEntries(pool).stream().filter(LootItem.class::isInstance).map(LootItem.class::cast).map(entry -> new LootSlot(entry.f_79564_, (float)entry.f_79675_ / totalWeight, min, max)).forEach(drops::add);
            LootLoader.getLootEntries(pool).stream().filter(LootTableReference.class::isInstance).map(LootTableReference.class::cast).map(entry -> LootLoader.crawlTable(manager.m_79217_(entry.f_79754_), manager)).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static List<LootPool> getPools(LootTable table) {
        return ((LootTableAccessor)table).getPools();
    }

    public static List<LootPoolEntryContainer> getLootEntries(LootPool pool) {
        return Arrays.asList(((LootPoolAccessor)pool).getEntries());
    }

    public static int getMin(NumberProvider randomRange, LootContext dummyContext) {
        if (randomRange instanceof ConstantValue) {
            return randomRange.m_142683_(dummyContext);
        }
        if (randomRange instanceof UniformGenerator) {
            UniformGenerator uniformGenerator = (UniformGenerator)randomRange;
            return Mth.m_14143_((float)uniformGenerator.f_165774_.m_142688_(dummyContext));
        }
        if (randomRange instanceof BinomialDistributionGenerator) {
            return 0;
        }
        return IntStream.iterate(0, i -> randomRange.m_142683_(dummyContext)).limit(100L).min().orElse(0);
    }

    public static int getMax(NumberProvider randomRange, LootContext dummyContext) {
        if (randomRange instanceof ConstantValue) {
            return randomRange.m_142683_(dummyContext);
        }
        if (randomRange instanceof UniformGenerator) {
            UniformGenerator uniformGenerator = (UniformGenerator)randomRange;
            return Mth.m_14143_((float)uniformGenerator.f_165775_.m_142688_(dummyContext));
        }
        if (randomRange instanceof BinomialDistributionGenerator) {
            BinomialDistributionGenerator binomialDistributionGenerator = (BinomialDistributionGenerator)randomRange;
            return binomialDistributionGenerator.f_165653_.m_142683_(dummyContext);
        }
        return IntStream.iterate(0, i -> randomRange.m_142683_(dummyContext)).limit(100L).max().orElse(0);
    }

    public static class LootSlot
    implements Supplier<Component> {
        public final Item item;
        public final int min;
        public final int max;
        public final float chance;

        public LootSlot(Item item, float chance, int min, int max) {
            this.item = item;
            this.min = min;
            this.max = max;
            this.chance = chance;
        }

        public LootSlot(FriendlyByteBuf buffer) {
            ItemStack item = buffer.m_130267_();
            this.item = item.m_41720_();
            this.min = item.m_41613_();
            this.max = buffer.readInt();
            this.chance = buffer.readFloat();
        }

        public ItemStack asStack() {
            return new ItemStack((ItemLike)this.item, this.min);
        }

        public String toString() {
            if (this.min == this.max) {
                return this.min + this.getDropChance();
            }
            return this.min + "-" + this.max + this.getDropChance();
        }

        private String getDropChance() {
            return this.chance < 1.0f ? " (" + this.formatChance() + "%)" : "";
        }

        private String formatChance() {
            float chance = this.chance * 100.0f;
            if (chance < 10.0f) {
                return String.format("%.1f", Float.valueOf(chance));
            }
            return String.format("%2d", (int)chance);
        }

        @Override
        public Component get() {
            return new TextComponent(this.toString());
        }

        public void toBuffer(FriendlyByteBuf buffer) {
            buffer.m_130055_(new ItemStack((ItemLike)this.item, this.min));
            buffer.writeInt(this.max);
            buffer.writeFloat(this.chance);
        }
    }
}

