/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.util;

import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.util.DropSimulationWorld;
import mod.noobulus.tetrapak.util.WrappedServerWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeHooks;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.ToolActionHelper;

public class BlockHelper {
    private BlockHelper() {
    }

    public static void destroyBlockAs(Level world, BlockPos pos, @Nullable Player player, ItemStack usedTool, float effectChance, BiConsumer<ItemStack, BlockState> droppedItemCallback) {
        Level unwrappedWorld = WrappedServerWorld.unwrap(world);
        FluidState fluidState = unwrappedWorld.m_6425_(pos);
        BlockState state = unwrappedWorld.m_8055_(pos);
        if (unwrappedWorld.f_46441_.nextFloat() < effectChance) {
            unwrappedWorld.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        if (player != null) {
            if (!(usedTool.m_41720_() instanceof ItemModularHandheld)) {
                usedTool.m_41686_(unwrappedWorld, state, pos, player);
            }
            BlockHelper.breakBlock(world, player, usedTool, pos);
        } else {
            unwrappedWorld.m_46597_(pos, fluidState.m_76188_());
        }
        if (world instanceof DropSimulationWorld) {
            DropSimulationWorld dropSimulationWorld = (DropSimulationWorld)world;
            dropSimulationWorld.getItems().forEach(stack -> droppedItemCallback.accept((ItemStack)stack, state));
        }
    }

    private static boolean breakBlock(Level world, @Nonnull Player player, ItemStack tool, BlockPos pos) {
        Level unwrappedWorld = WrappedServerWorld.unwrap(world);
        BlockState offsetState = unwrappedWorld.m_8055_(pos);
        if (ToolActionHelper.playerCanDestroyBlock((Player)player, (BlockState)offsetState, (BlockPos)pos, (ItemStack)tool) && BlockHelper.breakBlock(world, player, tool, pos, offsetState, true)) {
            EffectHelper.sendEventToPlayer((ServerPlayer)((ServerPlayer)player), (int)2001, (BlockPos)pos, (int)Block.m_49956_((BlockState)offsetState));
            CastOptional.cast((Object)tool.m_41720_(), ItemModularHandheld.class).ifPresent(itemHandheld -> itemHandheld.applyBreakEffects(tool, unwrappedWorld, offsetState, pos, (LivingEntity)player));
            return true;
        }
        return false;
    }

    public static boolean breakBlock(Level world, Player breakingPlayer, ItemStack toolStack, BlockPos pos, BlockState blockState, boolean harvest) {
        Level unwrappedWorld = WrappedServerWorld.unwrap(world);
        if (!unwrappedWorld.f_46443_ && unwrappedWorld instanceof ServerLevel) {
            boolean canRemove;
            ServerLevel serverWorld = (ServerLevel)unwrappedWorld;
            ServerPlayer serverPlayer = (ServerPlayer)breakingPlayer;
            GameType gameType = serverPlayer.f_8941_.m_9290_();
            int exp = ForgeHooks.onBlockBreakEvent((Level)serverWorld, (GameType)gameType, (ServerPlayer)serverPlayer, (BlockPos)pos);
            BlockEntity tileEntity = serverWorld.m_7702_(pos);
            if (exp == -1) {
                return false;
            }
            boolean bl = canRemove = !toolStack.onBlockStartBreak(pos, breakingPlayer) && !breakingPlayer.m_36187_((Level)serverWorld, pos, gameType) && (!harvest || blockState.canHarvestBlock((BlockGetter)serverWorld, pos, breakingPlayer)) && blockState.m_60734_().onDestroyedByPlayer(blockState, (Level)serverWorld, pos, breakingPlayer, harvest, serverWorld.m_6425_(pos));
            if (canRemove) {
                blockState.m_60734_().m_6786_((LevelAccessor)serverWorld, pos, blockState);
                if (harvest) {
                    blockState.m_60734_().m_6240_(world, breakingPlayer, pos, blockState, tileEntity, toolStack);
                    if (exp > 0) {
                        blockState.m_60734_().m_49805_(serverWorld, pos, exp);
                    }
                }
            }
            return canRemove;
        }
        return blockState.m_60734_().onDestroyedByPlayer(blockState, unwrappedWorld, pos, breakingPlayer, harvest, unwrappedWorld.m_6425_(pos));
    }
}

