/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.networking;

import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mod.noobulus.tetrapak.networking.ISimplePacket;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EntityFloatParticlePacket
implements ISimplePacket {
    private final int entityId;

    public EntityFloatParticlePacket(Entity entity) {
        this.entityId = entity.m_142049_();
    }

    public EntityFloatParticlePacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
    }

    @Override
    public void writePacketData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
            if (entity != null) {
                Vec3 pos = entity.m_20182_();
                Vec3 ppos = VecHelper.offsetRandomly((Vec3)pos, (Random)entity.f_19853_.f_46441_, (float)0.5f);
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, ppos.f_82479_, pos.f_82480_, ppos.f_82481_, 0.0, (double)-0.1f, 0.0);
            }
        });
        ctx.setPacketHandled(true);
    }
}

