/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.mixin;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.noobulus.tetrapak.predicate.PredicateManagers;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LighthingBoltPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPredicate.class})
public abstract class EntityPredicateMixin {
    private final List<Predicate<Entity>> customPredicates = new ArrayList<Predicate<Entity>>();

    @Inject(at={@At(value="RETURN")}, method={"fromJson"}, cancellable=true)
    private static void onFromJson(JsonElement element, CallbackInfoReturnable<EntityPredicate> cir) {
        if (PredicateManagers.ENTITY_PREDICATES.getRegistry() == null) {
            return;
        }
        List<Predicate<Entity>> predicateList = PredicateManagers.ENTITY_PREDICATES.getRegistry().getValues().stream().map(abstractEntityPredicate -> abstractEntityPredicate.read(element)).filter(Objects::nonNull).collect(Collectors.toList());
        if (predicateList.isEmpty()) {
            return;
        }
        EntityPredicate predicate = (EntityPredicate)cir.getReturnValue();
        if (predicate == EntityPredicate.f_36550_) {
            predicate = new EntityPredicate(EntityTypePredicate.f_37636_, DistancePredicate.f_26241_, LocationPredicate.f_52592_, LocationPredicate.f_52592_, MobEffectsPredicate.f_56547_, NbtPredicate.f_57471_, EntityFlagsPredicate.f_33682_, EntityEquipmentPredicate.f_32176_, PlayerPredicate.f_62244_, FishingHookPredicate.f_39756_, LighthingBoltPredicate.f_153232_, null, null);
            cir.setReturnValue((Object)predicate);
        }
        ((EntityPredicateMixin)predicate).bindPredicateList(predicateList);
    }

    @Inject(at={@At(value="RETURN")}, method={"matches(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    private void onPredicateTest(ServerLevel level, Vec3 vector3d, Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (this.customPredicates.isEmpty() || !cir.getReturnValueZ()) {
            return;
        }
        cir.setReturnValue((Object)this.customPredicates.stream().allMatch(entityPredicate -> entityPredicate.test(entity)));
    }

    public void bindPredicateList(List<Predicate<Entity>> list) {
        this.customPredicates.addAll(list);
    }
}

