/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.jei;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.noobulus.tetrapak.jei.AutoSalvageCategory;
import mod.noobulus.tetrapak.jei.CompatJeiRecipe;
import net.minecraftforge.fml.ModList;

public enum DynamicJeiCompat {
    CREATE("create", () -> AutoSalvageCategory::new);

    public final boolean isLoaded;
    private final Set<CompatJeiRecipe<?>> loadedCategories = new HashSet();

    @SafeVarargs
    private DynamicJeiCompat(String modid, Supplier<Supplier<CompatJeiRecipe<?>>> ... recipes) {
        this.isLoaded = ModList.get().isLoaded(modid);
        if (this.isLoaded) {
            Arrays.stream(recipes).map(Supplier::get).map(Supplier::get).forEach(this.loadedCategories::add);
        }
    }

    public static Set<CompatJeiRecipe<?>> getAllLoadedCategories() {
        return Arrays.stream(DynamicJeiCompat.values()).filter(DynamicJeiCompat::isLoaded).flatMap(DynamicJeiCompat::getLoadedCategories).collect(Collectors.toSet());
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    private Stream<CompatJeiRecipe<?>> getLoadedCategories() {
        return this.loadedCategories.stream();
    }
}

