/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.animations.AnimatedDeployer;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mod.noobulus.tetrapak.TetraPak;
import mod.noobulus.tetrapak.effects.create.recipes.SalvagingRecipe;
import mod.noobulus.tetrapak.jei.CompatJeiRecipe;
import mod.noobulus.tetrapak.jei.JeiTooltipEntry;
import mod.noobulus.tetrapak.util.LootLoader;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.items.modular.IModularItem;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AutoSalvageCategory
implements CompatJeiRecipe<SalvagingRecipe> {
    public static final ResourceLocation ID = TetraPak.asId("auto_salvage");
    private static final ItemStack hammer = AutoSalvageCategory.makeHammer();
    private final IDrawable background = new EmptyBackground(177, 90);
    private final IDrawable icon = new DoubleItemIcon(() -> new ItemStack((ItemLike)AllBlocks.DEPLOYER.get()), () -> hammer);
    private final AnimatedDeployer deployer = new AnimatedDeployer();

    private static ItemStack makeHammer() {
        Item modularDouble = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:modular_double"));
        if (modularDouble == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)modularDouble);
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/head_left", (String)"double/basic_hammer_left", (String)"double/basic_hammer_left_material", (String)"basic_hammer/iron");
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/head_right", (String)"double/basic_hammer_right", (String)"double/basic_hammer_right_material", (String)"basic_hammer/iron");
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/handle", (String)"double/basic_handle", (String)"double/basic_handle_material", (String)"basic_handle/spruce");
        IModularItem.updateIdentifier((ItemStack)itemStack);
        return itemStack;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends SalvagingRecipe> getRecipeClass() {
        return SalvagingRecipe.class;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SalvagingRecipe salvagingRecipe, IIngredients iIngredients) {
        iIngredients.setInputIngredients(Arrays.asList(salvagingRecipe.startingItem, Ingredient.m_43921_(salvagingRecipe.toolExamples.get().stream())));
        iIngredients.setOutputs(VanillaTypes.ITEM, salvagingRecipe.contents.get().stream().map(LootLoader.LootSlot::asStack).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, SalvagingRecipe salvagingRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, true, 26, 66);
        itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.init(1, true, 50, 19);
        itemStacks.set(1, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(1));
        Map<ItemStack, Supplier> tooltips = salvagingRecipe.contents.get().stream().collect(Collectors.toMap(LootLoader.LootSlot::asStack, lootSlot -> lootSlot));
        ArrayList<ItemStack> entries = new ArrayList<ItemStack>(tooltips.keySet());
        for (int i = 0; i < entries.size(); ++i) {
            int xOffset = i % 2 == 0 ? 0 : 19;
            int yOffset = i / 2 * -19;
            itemStacks.init(i + 2, false, 117 + xOffset, 67 + yOffset);
            itemStacks.set(i + 2, (ItemStack)entries.get(i));
        }
        ((List)iIngredients.getInputs(VanillaTypes.ITEM).get(1)).stream().findFirst().ifPresent(t -> tooltips.put((ItemStack)t, () -> new TranslatableComponent("tetrapak.tool_type." + salvagingRecipe.toolType.name())));
        iRecipeLayout.getItemStacks().addTooltipCallback(new JeiTooltipEntry<ItemStack>(tooltips));
    }

    @Override
    public RecipeType<SalvagingRecipe> getRecipeType() {
        return SalvagingRecipe.SalvagingRecipeType.AUTOMATIC_SALVAGING;
    }

    @Override
    public Collection<ItemStack> getCatalystIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)AllBlocks.DEPLOYER.get()));
    }

    public void draw(SalvagingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.render(matrixStack, 50, 19);
        AllGuiTextures.JEI_SLOT.render(matrixStack, 26, 65);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 62, 72);
        this.deployer.draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 37);
    }
}

