/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.entities;

import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mod.noobulus.tetrapak.registries.Entities;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FragileFallingBlock
extends FallingBlockEntity
implements IEntityAdditionalSpawnData {
    private NonNullList<ItemStack> drops;

    public FragileFallingBlock(EntityType<FragileFallingBlock> entityType, Level world) {
        super(entityType, world);
        this.drops = NonNullList.m_122779_();
    }

    public FragileFallingBlock(Level world, BlockPos pos, BlockState state, Collection<ItemStack> drops) {
        super((EntityType)Entities.FRAGILE_FALLING_BLOCK.get(), world);
        this.drops = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])drops.toArray(new ItemStack[0]));
        this.f_31946_ = state;
        this.f_19850_ = true;
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + (double)(1.0f - this.m_20206_()) / 2.0, (double)pos.m_123343_() + 0.5);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = (double)pos.m_123341_() + 0.5;
        this.f_19855_ = pos.m_123342_();
        this.f_19856_ = (double)pos.m_123343_() + 0.5;
        this.m_31959_(this.m_142538_());
    }

    public void m_8119_() {
        if (!this.m_6084_()) {
            return;
        }
        if (this.m_31980_().m_60795_()) {
            this.dropItems();
            return;
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.f_19861_ || this.f_31942_ > 100 && (this.m_20186_() < -63.0 || this.m_20186_() > 320.0) || this.f_31942_ > 600) {
            this.dropItems();
            return;
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    private void dropItems() {
        if (!this.f_19853_.f_46443_ && this.f_31943_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.drops.forEach(stack -> Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (ItemStack)stack));
        }
        this.m_146870_();
    }

    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.drops);
    }

    protected void m_7378_(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        super.m_7378_(nbt);
        this.drops = NonNullList.m_122780_((int)nbt.m_128437_("Items", 10).size(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.drops);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        buffer.m_130079_(compound);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_7378_(additionalData.m_130260_());
    }
}

