/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.quark;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import mod.noobulus.tetrapak.TetraPak;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.MaterialColor;

public final class CorundumMap {
    public static final Map<MaterialColor, Integer> COLOR_MAP = new HashMap<MaterialColor, Integer>();
    public static final Map<Integer, ResourceLocation> CRYSTAL_MAP = new HashMap<Integer, ResourceLocation>();
    public static final Map<Integer, String> NAME_MAP = new HashMap<Integer, String>();
    private static final int RED = 1;
    private static final int ORANGE = 2;
    private static final int YELLOW = 3;
    private static final int GREEN = 4;
    private static final int BLUE = 5;
    private static final int INDIGO = 6;
    private static final int VIOLET = 7;
    private static final int WHITE = 8;
    private static final int BLACK = 9;

    private CorundumMap() {
    }

    private static ResourceLocation asQuarkCrystal(String color) {
        return new ResourceLocation("quark", color + "_crystal_cluster");
    }

    public static void checkMappings() {
        TetraPak.LOGGER.info("Checking corundum color mappings...");
        Arrays.stream(MaterialColor.f_76387_).filter(((Predicate<MaterialColor>)COLOR_MAP::containsKey).negate()).filter(Objects::nonNull).forEach(materialColor -> TetraPak.LOGGER.error("Material color {} of id {} and colour {} was not mapped to a corundum variant", materialColor, (Object)materialColor.f_76397_, (Object)materialColor.f_76396_));
    }

    static {
        COLOR_MAP.put(MaterialColor.f_76398_, 9);
        COLOR_MAP.put(MaterialColor.f_76399_, 4);
        COLOR_MAP.put(MaterialColor.f_76400_, 3);
        COLOR_MAP.put(MaterialColor.f_76401_, 8);
        COLOR_MAP.put(MaterialColor.f_76402_, 1);
        COLOR_MAP.put(MaterialColor.f_76403_, 6);
        COLOR_MAP.put(MaterialColor.f_76404_, 8);
        COLOR_MAP.put(MaterialColor.f_76405_, 4);
        COLOR_MAP.put(MaterialColor.f_76406_, 8);
        COLOR_MAP.put(MaterialColor.f_76407_, 8);
        COLOR_MAP.put(MaterialColor.f_76408_, 2);
        COLOR_MAP.put(MaterialColor.f_76409_, 9);
        COLOR_MAP.put(MaterialColor.f_76410_, 5);
        COLOR_MAP.put(MaterialColor.f_76411_, 2);
        COLOR_MAP.put(MaterialColor.f_76412_, 8);
        COLOR_MAP.put(MaterialColor.f_76413_, 2);
        COLOR_MAP.put(MaterialColor.f_76414_, 6);
        COLOR_MAP.put(MaterialColor.f_76415_, 5);
        COLOR_MAP.put(MaterialColor.f_76416_, 3);
        COLOR_MAP.put(MaterialColor.f_76417_, 4);
        COLOR_MAP.put(MaterialColor.f_76418_, 7);
        COLOR_MAP.put(MaterialColor.f_76419_, 9);
        COLOR_MAP.put(MaterialColor.f_76420_, 8);
        COLOR_MAP.put(MaterialColor.f_76421_, 5);
        COLOR_MAP.put(MaterialColor.f_76422_, 6);
        COLOR_MAP.put(MaterialColor.f_76361_, 5);
        COLOR_MAP.put(MaterialColor.f_76362_, 2);
        COLOR_MAP.put(MaterialColor.f_76363_, 4);
        COLOR_MAP.put(MaterialColor.f_76364_, 1);
        COLOR_MAP.put(MaterialColor.f_76365_, 9);
        COLOR_MAP.put(MaterialColor.f_76366_, 3);
        COLOR_MAP.put(MaterialColor.f_76367_, 5);
        COLOR_MAP.put(MaterialColor.f_76368_, 5);
        COLOR_MAP.put(MaterialColor.f_76369_, 4);
        COLOR_MAP.put(MaterialColor.f_76370_, 2);
        COLOR_MAP.put(MaterialColor.f_76371_, 1);
        COLOR_MAP.put(MaterialColor.f_76372_, 8);
        COLOR_MAP.put(MaterialColor.f_76373_, 2);
        COLOR_MAP.put(MaterialColor.f_76374_, 6);
        COLOR_MAP.put(MaterialColor.f_76375_, 5);
        COLOR_MAP.put(MaterialColor.f_76376_, 3);
        COLOR_MAP.put(MaterialColor.f_76377_, 4);
        COLOR_MAP.put(MaterialColor.f_76378_, 7);
        COLOR_MAP.put(MaterialColor.f_76379_, 9);
        COLOR_MAP.put(MaterialColor.f_76380_, 8);
        COLOR_MAP.put(MaterialColor.f_76381_, 5);
        COLOR_MAP.put(MaterialColor.f_76382_, 6);
        COLOR_MAP.put(MaterialColor.f_76383_, 5);
        COLOR_MAP.put(MaterialColor.f_76384_, 2);
        COLOR_MAP.put(MaterialColor.f_76385_, 4);
        COLOR_MAP.put(MaterialColor.f_76386_, 1);
        COLOR_MAP.put(MaterialColor.f_76388_, 9);
        COLOR_MAP.put(MaterialColor.f_76389_, 1);
        COLOR_MAP.put(MaterialColor.f_76390_, 1);
        COLOR_MAP.put(MaterialColor.f_76391_, 1);
        COLOR_MAP.put(MaterialColor.f_76392_, 5);
        COLOR_MAP.put(MaterialColor.f_76393_, 5);
        COLOR_MAP.put(MaterialColor.f_76394_, 5);
        COLOR_MAP.put(MaterialColor.f_76395_, 5);
        CRYSTAL_MAP.put(1, CorundumMap.asQuarkCrystal("red"));
        CRYSTAL_MAP.put(2, CorundumMap.asQuarkCrystal("orange"));
        CRYSTAL_MAP.put(3, CorundumMap.asQuarkCrystal("yellow"));
        CRYSTAL_MAP.put(4, CorundumMap.asQuarkCrystal("green"));
        CRYSTAL_MAP.put(5, CorundumMap.asQuarkCrystal("blue"));
        CRYSTAL_MAP.put(6, CorundumMap.asQuarkCrystal("indigo"));
        CRYSTAL_MAP.put(7, CorundumMap.asQuarkCrystal("violet"));
        CRYSTAL_MAP.put(8, CorundumMap.asQuarkCrystal("white"));
        CRYSTAL_MAP.put(9, CorundumMap.asQuarkCrystal("black"));
        NAME_MAP.put(1, "red");
        NAME_MAP.put(2, "orange");
        NAME_MAP.put(3, "yellow");
        NAME_MAP.put(4, "green");
        NAME_MAP.put(5, "blue");
        NAME_MAP.put(6, "indigo");
        NAME_MAP.put(7, "violet");
        NAME_MAP.put(8, "white");
        NAME_MAP.put(9, "black");
    }
}

