/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.create.refined_radiance;

import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.Config;
import mod.noobulus.tetrapak.effects.create.refined_radiance.BlockCollection;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;

public class UnearthingEffect
implements IHoloDescription,
IEventBusListener {
    private static boolean unearthing = false;

    public static void unearth(LevelAccessor iWorld, BlockPos pos, Player entity) {
        if (unearthing || entity.m_6144_() || !(iWorld instanceof Level)) {
            return;
        }
        Level world = (Level)iWorld;
        unearthing = true;
        UnearthingEffect.findOreVein((BlockGetter)world, pos).destroyBlocks(world, (LivingEntity)entity, (dropPos, stack) -> Block.m_49840_((Level)world, (BlockPos)dropPos, (ItemStack)stack));
        unearthing = false;
    }

    public static BlockCollection findOreVein(@Nullable BlockGetter world, BlockPos pos) {
        if (world == null) {
            return BlockCollection.EMPTY;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        Block start = world.m_8055_(pos).m_60734_();
        if (!Tags.Blocks.ORES.m_8110_((Object)start)) {
            return BlockCollection.EMPTY;
        }
        frontier.add(pos);
        while (!frontier.isEmpty()) {
            BlockPos current = (BlockPos)frontier.remove(0);
            visited.add(current);
            for (Direction direction : Direction.values()) {
                BlockPos offset = current.m_142300_(direction);
                if (visited.contains(offset) || !start.equals(world.m_8055_(offset).m_60734_())) continue;
                frontier.add(offset);
            }
            if (visited.size() < (Integer)Config.MAX_RADIANT_BLOCKS.get()) continue;
            return new BlockCollection(visited);
        }
        return new BlockCollection(visited);
    }

    @SubscribeEvent
    public void unearthWhenBlockBroken(BlockEvent.BreakEvent event) {
        if (!unearthing && this.hasEffect(event.getPlayer().m_21205_())) {
            UnearthingEffect.unearth(event.getWorld(), event.getPos(), event.getPlayer());
        }
    }

    @Override
    public ITooltipGetter getStatTooltipGetter(IStatGetter statGetter) {
        return (player, itemStack) -> I18n.m_118938_((String)this.getTooltipPath(), (Object[])new Object[]{Config.MAX_RADIANT_BLOCKS.get()});
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("unearthing");
    }
}

