/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.create.refined_radiance;

import java.util.HashSet;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.effects.create.refined_radiance.BlockCollection;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.util.ToolActionHelper;

public class CollapsingEffect
implements IHoloDescription,
IEventBusListener {
    private static boolean collapsing = false;

    public static void collapse(LevelAccessor iWorld, BlockPos pos, Player entity) {
        if (collapsing || entity.m_6144_() || !(iWorld instanceof Level)) {
            return;
        }
        Level world = (Level)iWorld;
        collapsing = true;
        CollapsingEffect.findDirtColumn((BlockGetter)world, pos).destroyBlocksFancy(world, (LivingEntity)entity);
        collapsing = false;
    }

    public static BlockCollection findDirtColumn(@Nullable BlockGetter world, BlockPos pos) {
        if (world == null) {
            return BlockCollection.EMPTY;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockState startState = world.m_8055_(pos);
        while (CollapsingEffect.canBreakWithStart(startState, world.m_8055_(pos))) {
            visited.add(pos);
            pos = pos.m_7494_();
        }
        return new BlockCollection(visited);
    }

    public static boolean canBreakWithStart(BlockState start, BlockState test) {
        if (!ToolActionHelper.isEffectiveOn((ToolAction)ToolActions.SHOVEL_DIG, (BlockState)test)) {
            return false;
        }
        if (test.m_60734_() instanceof FallingBlock) {
            return true;
        }
        if (start.m_60734_().equals(test.m_60734_())) {
            return true;
        }
        return Material.f_76314_.equals(CollapsingEffect.getBlockMaterial(start)) && (Material.f_76314_.equals(CollapsingEffect.getBlockMaterial(test)) || test.m_60734_().equals(Blocks.f_50440_));
    }

    private static Material getBlockMaterial(BlockState state) {
        return state.m_60767_();
    }

    @SubscribeEvent
    public void collapseWhenBlockBroken(BlockEvent.BreakEvent event) {
        if (!collapsing && this.hasEffect(event.getPlayer().m_21205_())) {
            CollapsingEffect.collapse(event.getWorld(), event.getPos(), event.getPlayer());
        }
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("collapsing");
    }
}

