/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.create.refined_radiance;

import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.entities.FragileFallingBlock;
import mod.noobulus.tetrapak.util.BlockHelper;
import mod.noobulus.tetrapak.util.DropSimulationWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.util.TriConsumer;

public class BlockCollection
extends AbstractBlockBreakQueue {
    public static final BlockCollection EMPTY = new BlockCollection(Collections.emptyList());
    private final Collection<BlockPos> blocks;

    public BlockCollection(Collection<BlockPos> blocks) {
        this.blocks = blocks;
    }

    public void destroyBlocks(Level world, ItemStack itemStack, @Nullable Player playerEntity, TriConsumer<BlockPos, BlockState, ItemStack> drop) {
        this.blocks.forEach(this.makeCallbackFor(world, 0.125f, itemStack, playerEntity, drop));
    }

    public void destroyBlocks(Level world, @Nullable LivingEntity entity, TriConsumer<BlockPos, BlockState, ItemStack> drop) {
        Player player;
        Player playerEntity = entity instanceof Player ? (player = (Player)entity) : null;
        ItemStack toDamage = playerEntity != null && !playerEntity.m_7500_() ? playerEntity.m_21205_() : ItemStack.f_41583_;
        this.destroyBlocks(world, toDamage, playerEntity, drop);
    }

    public void destroyBlocksFancy(Level world, @Nullable LivingEntity entity) {
        HashMap<Pair, Collection> drops = new HashMap<Pair, Collection>();
        this.destroyBlocks(world, entity, (TriConsumer<BlockPos, BlockState, ItemStack>)((TriConsumer)(pos, state, stack) -> {
            Pair key = Pair.of((Object)pos, (Object)state);
            Collection<ItemStack> dropsAt = drops.containsKey(key) ? (Collection)drops.get(key) : new ArrayList();
            dropsAt.add((ItemStack)stack);
            drops.put(key, dropsAt);
        }));
        if (!world.f_46443_) {
            drops.forEach((inf, itemStacks) -> world.m_7967_((Entity)new FragileFallingBlock(world, (BlockPos)inf.getFirst(), (BlockState)inf.getSecond(), (Collection<ItemStack>)itemStacks)));
        }
    }

    protected Consumer<BlockPos> makeCallbackFor(Level world, float effectChance, ItemStack toDamage, @Nullable Player playerEntity, TriConsumer<BlockPos, BlockState, ItemStack> drop) {
        Level simulationWorld = DropSimulationWorld.of(world);
        return pos -> {
            ItemStack usedTool = toDamage.m_41777_();
            BlockHelper.destroyBlockAs(simulationWorld, pos, playerEntity, toDamage, effectChance, (stack, state) -> drop.accept(pos, state, stack));
            if (toDamage.m_41619_() && !usedTool.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)playerEntity, (ItemStack)usedTool, (InteractionHand)InteractionHand.MAIN_HAND);
            }
        };
    }

    public void destroyBlocks(Level world, ItemStack itemStack, @Nullable Player playerEntity, BiConsumer<BlockPos, ItemStack> biConsumer) {
        this.destroyBlocks(world, itemStack, playerEntity, (TriConsumer<BlockPos, BlockState, ItemStack>)((TriConsumer)(pos, state, stack) -> biConsumer.accept((BlockPos)pos, (ItemStack)stack)));
    }
}

