/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.create;

import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import java.util.UUID;
import mod.noobulus.tetrapak.Mods;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.classloading.GetSudsParticle;
import mod.noobulus.tetrapak.util.tetra_definitions.IPercentageHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;

public class NullifyingEffect
implements IPercentageHoloDescription,
IEventBusListener {
    public static final AttributeModifier beltGravityModifier = new AttributeModifier(UUID.fromString("678c7388-ba1d-45c8-9f51-d6e4f1c4e3ac"), "Gravity modifier", -0.75, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final AttributeModifier beltDoubleGravityModifier = new AttributeModifier(UUID.fromString("778c7388-ba1d-45c8-9f51-d6e4f1c4e3ac"), "Gravity modifier", -0.875, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final AttributeModifier beltGravityModifierSlowfall = new AttributeModifier(UUID.fromString("878c7388-ba1d-45c8-9f51-d6e4f1c4e3ac"), "Gravity modifier", -0.65, AttributeModifier.Operation.MULTIPLY_TOTAL);

    private static void updateEffect(boolean active, AttributeInstance attributeInstance, AttributeModifier modifier) {
        if (active) {
            if (!attributeInstance.m_22109_(modifier)) {
                attributeInstance.m_22118_(modifier);
            }
        } else if (attributeInstance.m_22109_(modifier)) {
            attributeInstance.m_22130_(modifier);
        }
    }

    @Override
    public void doBeltTick(Player player, int nullifierLevel) {
        AttributeInstance gravityAttribute = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (nullifierLevel < 0 || gravityAttribute == null) {
            return;
        }
        boolean slowfall = player.m_21023_(MobEffects.f_19591_);
        NullifyingEffect.updateEffect(nullifierLevel == 1 && !slowfall, gravityAttribute, beltGravityModifier);
        NullifyingEffect.updateEffect(nullifierLevel == 2 && !slowfall, gravityAttribute, beltDoubleGravityModifier);
        NullifyingEffect.updateEffect(nullifierLevel > 0 && slowfall, gravityAttribute, beltGravityModifierSlowfall);
        if (nullifierLevel > 0 && player.m_20184_().m_7098_() < 0.0) {
            player.f_19789_ = 1.0f;
        }
        if (nullifierLevel > 0 && player.m_20184_().m_7098_() >= 0.0) {
            player.f_19789_ = 0.0f;
        }
        if (player.f_19853_.f_46443_) {
            Vec3 pos = player.m_20182_();
            if (player.f_19853_.f_46441_.nextFloat() < (float)nullifierLevel / 2.0f) {
                Vec3 basemotion = VecHelper.offsetRandomly((Vec3)pos, (Random)player.f_19853_.f_46441_, (float)0.5f);
                if (Mods.SUPPLEMENTARIES.isLoaded && NullifyingEffect.hasBubbler(player)) {
                    player.f_19853_.m_7106_((ParticleOptions)GetSudsParticle.getSudsParticle(), basemotion.f_82479_, pos.f_82480_, basemotion.f_82481_, 0.0, (double)-0.1f, 0.0);
                } else {
                    player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, basemotion.f_82479_, pos.f_82480_, basemotion.f_82481_, 0.0, (double)-0.1f, 0.0);
                }
            }
        }
    }

    private static boolean hasBubbler(Player player) {
        ItemStack itemStack = ToolbeltHelper.findToolbelt((Player)player);
        return NullifyingEffect.getBubblerLevel(itemStack) > 0;
    }

    private static int getBubblerLevel(ItemStack itemStack) {
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof IModularItem) {
            IModularItem item = (IModularItem)itemStack.m_41720_();
            int lvl = item.getEffectLevel(itemStack, ItemEffect.get((String)"tetrapak:bubbling"));
            return lvl;
        }
        return 0;
    }

    @SubscribeEvent
    public void onFarmlandTrampled(BlockEvent.FarmlandTrampleEvent event) {
        if (this.hasBeltEffect(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @Override
    public double getStatMultiplier() {
        return 12.5;
    }

    @Override
    public double getStatBase() {
        return 62.5;
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("nullifying");
    }
}

