/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.effects.base;

import javax.annotation.Nullable;
import mod.noobulus.tetrapak.util.DamageBufferer;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.MathHelper;
import mod.noobulus.tetrapak.util.tetra_definitions.IPercentageHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;

public class ExpBoostEffect
implements IPercentageHoloDescription,
IEventBusListener {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void boostExpFromKills(LivingExperienceDropEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource lastActive = DamageBufferer.getLastActiveDamageSource();
        if (this.shouldExpBoostAffect(lastActive, (Entity)target)) {
            event.setDroppedExperience(MathHelper.doubleToIntWithChance((double)event.getDroppedExperience() * (1.0 + this.getEffectEfficiency(lastActive) / 100.0)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void boostExpFromBlocks(BlockEvent.BreakEvent event) {
        ItemStack heldItemMainhand = event.getPlayer().m_21205_();
        if (this.hasEffect(heldItemMainhand)) {
            event.setExpToDrop(MathHelper.doubleToIntWithChance((double)event.getExpToDrop() * (1.0 + this.getEffectEfficiency(heldItemMainhand) / 100.0)));
        }
    }

    private boolean shouldExpBoostAffect(@Nullable DamageSource source, Entity target) {
        if (target instanceof Player) {
            return false;
        }
        return this.hasEffect(source);
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("expboost");
    }
}

