/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.noobulus.tetrapak.effects.base.ExpBoostEffect;
import mod.noobulus.tetrapak.effects.base.RegrowthEffect;
import mod.noobulus.tetrapak.effects.base.ScorchingEffect;
import mod.noobulus.tetrapak.effects.create.NullifyingEffect;
import mod.noobulus.tetrapak.effects.create.SolidifyingEffect;
import mod.noobulus.tetrapak.effects.create.StandardTetraPakAttributes;
import mod.noobulus.tetrapak.effects.create.VoidingEffect;
import mod.noobulus.tetrapak.effects.create.refined_radiance.CollapsingEffect;
import mod.noobulus.tetrapak.effects.create.refined_radiance.DeforestingEffect;
import mod.noobulus.tetrapak.effects.create.refined_radiance.FloatingEffect;
import mod.noobulus.tetrapak.effects.create.refined_radiance.UnearthingEffect;
import mod.noobulus.tetrapak.effects.druidcraft.MoonsightEffect;
import mod.noobulus.tetrapak.effects.druidcraft.MoonstrikeEffect;
import mod.noobulus.tetrapak.effects.eidolon.CleavingEffect;
import mod.noobulus.tetrapak.effects.eidolon.ReapingEffect;
import mod.noobulus.tetrapak.effects.quark.CorundumEffect;
import mod.noobulus.tetrapak.effects.supplementaries.BubblingEffect;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ILootModifier;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;

public enum Mods {
    TETRA("tetra", () -> RegrowthEffect::new, () -> ScorchingEffect::new, () -> ExpBoostEffect::new),
    CREATE("create", () -> CollapsingEffect::new, () -> DeforestingEffect::new, () -> UnearthingEffect::new, () -> NullifyingEffect::new, () -> VoidingEffect::new, () -> SolidifyingEffect::new, () -> () -> FloatingEffect.INSTANCE, () -> StandardTetraPakAttributes::register),
    DRUIDCRAFT("druidcraft", () -> MoonstrikeEffect::new, () -> MoonsightEffect::new),
    QUARK("quark", () -> CorundumEffect::new),
    EIDOLON("eidolon", () -> ReapingEffect::new, () -> CleavingEffect::new),
    SUPPLEMENTARIES("supplementaries", () -> BubblingEffect::new);

    public final boolean isLoaded;
    private final Set<Object> loadedListeners = new HashSet<Object>();

    @SafeVarargs
    private Mods(String modid, Supplier<Supplier<Object>> ... eventListeners) {
        this.isLoaded = ModList.get().isLoaded(modid);
        if (this.isLoaded) {
            Arrays.stream(eventListeners).map(Supplier::get).map(Supplier::get).filter(Objects::nonNull).forEach(this.loadedListeners::add);
        }
    }

    private static Stream<Object> getLoadedListenersStream() {
        return Arrays.stream(Mods.values()).flatMap(mods -> mods.loadedListeners.stream());
    }

    public static void registerEventListeners() {
        Mods.getLoadedListenersStream().filter(IEventBusListener.class::isInstance).map(IEventBusListener.class::cast).forEach(IEventBusListener::register);
        MinecraftForge.EVENT_BUS.register(Mods.class);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        Mods.getLoadedListenersStream().filter(IHoloDescription.class::isInstance).map(IHoloDescription.class::cast).forEach(IHoloDescription::clientInit);
    }

    public static void registerLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        Mods.getLoadedListenersStream().filter(ILootModifier.class::isInstance).map(ILootModifier.class::cast).map(ILootModifier::getModifier).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public static void handlebeltTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack belt = ToolbeltHelper.findToolbelt((Player)player);
        Mods.getLoadedListenersStream().filter(ITetraEffect.class::isInstance).map(ITetraEffect.class::cast).forEach(tetraEffect -> tetraEffect.doBeltTick(player, belt));
    }
}

