/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.feet;

import artifacts.common.capability.SwimHandler;
import artifacts.common.item.curio.CurioItem;
import be.florens.expandability.api.forge.LivingFluidCollisionEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.eventbus.api.Event;
import top.theillusivec4.curios.api.SlotContext;

public class AquaDashersItem
extends CurioItem {
    public AquaDashersItem() {
        this.addListener(LivingFluidCollisionEvent.class, this::onFluidCollision);
    }

    private void onFluidCollision(LivingFluidCollisionEvent event, LivingEntity wearer) {
        if (wearer.m_20142_() && wearer.f_19789_ < 6.0f && !wearer.m_6117_() && !wearer.m_6047_()) {
            wearer.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
                if (!handler.isWet() && !handler.isSwimming()) {
                    event.setResult(Event.Result.ALLOW);
                    if (event.getFluidState().m_76153_((Tag)FluidTags.f_13132_) && !wearer.m_5825_() && !EnchantmentHelper.m_44938_((LivingEntity)wearer)) {
                        wearer.m_6469_(DamageSource.f_19309_, 1.0f);
                    }
                }
            });
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity().f_19797_ % 20 == 0 && this.isSprintingOnFluid(slotContext.entity())) {
            this.damageStack(slotContext, stack);
        }
    }

    public boolean isSprinting(LivingEntity entity) {
        return this.isEquippedBy(entity) && entity.m_20142_() && entity.f_19789_ < 6.0f && entity.getCapability(SwimHandler.CAPABILITY).map(SwimHandler::isWet).orElse(true) == false;
    }

    private boolean isSprintingOnFluid(LivingEntity entity) {
        if (this.isSprinting(entity)) {
            BlockPos pos = new BlockPos(Mth.m_14107_((double)entity.m_20185_()), Mth.m_14107_((double)(entity.m_20186_() - 0.2)), Mth.m_14107_((double)entity.m_20189_()));
            return !entity.f_19853_.m_8055_(pos).m_60819_().m_76178_();
        }
        return false;
    }
}

