/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio.model;

import artifacts.client.render.curio.CurioLayers;
import artifacts.client.render.curio.CurioRenderers;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class BeltModel
extends HumanoidModel<LivingEntity> {
    protected final ModelPart charm;
    private final float xOffset;
    private final float zOffset;
    private final float rotation;

    public BeltModel(ModelPart part, Function<ResourceLocation, RenderType> renderType, float xOffset, float zOffset, float rotation) {
        super(part, renderType);
        this.charm = this.f_102810_.m_171324_("charm");
        this.xOffset = xOffset;
        this.zOffset = zOffset;
        this.rotation = rotation;
    }

    public BeltModel(ModelPart part, float xOffset, float zOffset, float rotation) {
        this(part, RenderType::m_110458_, xOffset, zOffset, rotation);
    }

    public void setCharmPosition(int slot) {
        float xOffset = slot % 2 == 0 ? this.xOffset : -this.xOffset;
        float zOffset = slot % 4 < 2 ? this.zOffset : -this.zOffset;
        this.charm.m_104227_(xOffset, 9.0f, zOffset);
        float rotation = slot % 4 < 2 ? 0.0f : (float)(-Math.PI);
        this.charm.f_104204_ = rotation += slot % 2 == 0 ^ slot % 4 >= 2 ? this.rotation : -this.rotation;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_);
    }

    public static BeltModel createCloudInABottleModel() {
        return new BeltModel(CurioRenderers.bakeLayer(CurioLayers.CLOUD_IN_A_BOTTLE), RenderType::m_110473_, 3.0f, -3.0f, -0.5f){
            private final ModelPart cloud;
            {
                this.cloud = this.charm.m_171324_("cloud");
            }

            public void m_6973_(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.cloud.f_104204_ = ageInTicks / 50.0f;
                this.cloud.f_104201_ = Mth.m_14089_((float)(ageInTicks / 30.0f)) / 2.0f;
            }
        };
    }

    public static HumanoidModel<LivingEntity> createHeliumFlamingoModel() {
        ModelPart part = CurioRenderers.bakeLayer(CurioLayers.HELIUM_FLAMINGO);
        return new HumanoidModel<LivingEntity>(part, RenderType::m_110458_){

            protected Iterable<ModelPart> m_5607_() {
                return ImmutableList.of();
            }

            protected Iterable<ModelPart> m_5608_() {
                return ImmutableList.of((Object)this.f_102810_);
            }
        };
    }

    public static BeltModel createObsidianSkullModel() {
        return new BeltModel(CurioRenderers.bakeLayer(CurioLayers.OBSIDIAN_SKULL), 4.5f, -4.0f, -0.5f);
    }

    public static BeltModel createAntidoteVesselModel() {
        return new BeltModel(CurioRenderers.bakeLayer(CurioLayers.ANTIDOTE_VESSEL), 4.0f, -3.0f, -0.5f);
    }

    public static BeltModel createUniversalAttractorModel() {
        return new BeltModel(CurioRenderers.bakeLayer(CurioLayers.UNIVERSAL_ATTRACTOR), 2.5f, -3.0f, 0.0f);
    }

    public static BeltModel createCrystalHeartModel() {
        return new BeltModel(CurioRenderers.bakeLayer(CurioLayers.CRYSTAL_HEART), RenderType::m_110473_, 2.5f, -3.01f, 0.0f);
    }

    private static MeshDefinition createBelt(CubeListBuilder charm) {
        CubeDeformation deformation = new CubeDeformation(0.5f);
        MeshDefinition mesh = BeltModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.f_171404_);
        mesh.m_171576_().m_171597_("body").m_171599_("charm", charm, PartPose.f_171404_);
        return mesh;
    }

    public static MeshDefinition createAntidoteVessel() {
        CubeListBuilder charm = CubeListBuilder.m_171558_();
        charm.m_171514_(0, 16);
        charm.m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f);
        charm.m_171514_(0, 26);
        charm.m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f);
        return BeltModel.createBelt(charm);
    }

    public static MeshDefinition createCloudInABottle() {
        CubeListBuilder charm = CubeListBuilder.m_171558_();
        charm.m_171514_(0, 16);
        charm.m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f);
        charm.m_171514_(0, 25);
        charm.m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f);
        MeshDefinition mesh = BeltModel.createBelt(charm);
        mesh.m_171576_().m_171597_("body").m_171597_("charm").m_171599_("cloud", CubeListBuilder.m_171558_().m_171514_(8, 25).m_171481_(-1.0f, 1.5f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.f_171404_);
        return mesh;
    }

    public static MeshDefinition createCrystalHeart() {
        CubeListBuilder charm = CubeListBuilder.m_171558_();
        charm.m_171514_(0, 16);
        charm.m_171481_(-2.5f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f);
        charm.m_171514_(6, 16);
        charm.m_171481_(0.5f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f);
        charm.m_171514_(0, 20);
        charm.m_171481_(-0.5f, 1.0f, 0.0f, 1.0f, 4.0f, 1.0f);
        charm.m_171514_(4, 20);
        charm.m_171481_(-1.5f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        charm.m_171514_(8, 20);
        charm.m_171481_(0.5f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return BeltModel.createBelt(charm);
    }

    public static MeshDefinition createHeliumFlamingo() {
        MeshDefinition mesh = BeltModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 36).m_171481_(-1.0f, 1.0f, -14.0f, 2.0f, 3.0f, 5.0f).m_171514_(0, 18).m_171481_(4.0f, 9.0f, -7.0f, 4.0f, 4.0f, 14.0f).m_171514_(0, 0).m_171481_(-8.0f, 9.0f, -7.0f, 4.0f, 4.0f, 14.0f).m_171514_(36, 0).m_171481_(-4.0f, 9.0f, 3.0f, 8.0f, 4.0f, 4.0f).m_171514_(36, 8).m_171481_(-4.0f, 9.0f, -7.0f, 8.0f, 4.0f, 4.0f).m_171514_(0, 36).m_171481_(-2.0f, 1.0f, -9.0f, 4.0f, 11.0f, 4.0f), PartPose.f_171404_);
        return mesh;
    }

    public static MeshDefinition createObsidianSkull() {
        CubeListBuilder charm = CubeListBuilder.m_171558_();
        charm.m_171514_(0, 16);
        charm.m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 3.0f, 4.0f);
        charm.m_171514_(18, 16);
        charm.m_171481_(-1.5f, 3.0f, 0.0f, 1.0f, 1.0f, 2.0f);
        charm.m_171514_(18, 19);
        charm.m_171481_(0.5f, 3.0f, 0.0f, 1.0f, 1.0f, 2.0f);
        return BeltModel.createBelt(charm);
    }

    public static MeshDefinition createUniversalAttractor() {
        CubeListBuilder charm = CubeListBuilder.m_171558_();
        charm.m_171514_(0, 16);
        charm.m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 2.0f, 1.0f);
        charm.m_171514_(0, 19);
        charm.m_171481_(-2.5f, 2.0f, 0.0f, 2.0f, 4.0f, 1.0f);
        charm.m_171514_(6, 19);
        charm.m_171481_(0.5f, 2.0f, 0.0f, 2.0f, 4.0f, 1.0f);
        return BeltModel.createBelt(charm);
    }
}

