/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.actors.SeatBlock;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockHelper {
    public static BlockState setZeroAge(BlockState blockState) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61405_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61405_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61406_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61407_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61408_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61408_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61409_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61410_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61411_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61411_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61421_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61421_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61416_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61416_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61387_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61387_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_60620_((Tag)BlockTags.f_144269_)) {
            return ((Block)Blocks.f_50256_.delegate.get()).m_49966_();
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61419_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61419_, (Comparable)Integer.valueOf(0));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61432_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61432_, (Comparable)Boolean.valueOf(false));
        }
        return blockState;
    }

    public static int findAndRemoveInInventory(BlockState block, Player player, int amount) {
        int taken;
        boolean needsTwo;
        int amountFound = 0;
        Item required = BlockHelper.getRequiredItem(block).m_41720_();
        boolean bl = needsTwo = block.m_61138_((Property)BlockStateProperties.f_61397_) && block.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.DOUBLE;
        if (needsTwo) {
            amount *= 2;
        }
        if (block.m_61138_((Property)BlockStateProperties.f_61415_)) {
            amount *= ((Integer)block.m_61143_((Property)BlockStateProperties.f_61415_)).intValue();
        }
        if (block.m_61138_((Property)BlockStateProperties.f_61425_)) {
            amount *= ((Integer)block.m_61143_((Property)BlockStateProperties.f_61425_)).intValue();
        }
        int preferredSlot = player.m_150109_().f_35977_;
        ItemStack itemstack = player.m_150109_().m_8020_(preferredSlot);
        int count = itemstack.m_41613_();
        if (itemstack.m_41720_() == required && count > 0) {
            taken = Math.min(count, amount - amountFound);
            player.m_150109_().m_6836_(preferredSlot, new ItemStack((ItemLike)itemstack.m_41720_(), count - taken));
            amountFound += taken;
        }
        for (int i = 0; i < player.m_150109_().m_6643_() && amountFound != amount; ++i) {
            itemstack = player.m_150109_().m_8020_(i);
            count = itemstack.m_41613_();
            if (itemstack.m_41720_() != required || count <= 0) continue;
            taken = Math.min(count, amount - amountFound);
            player.m_150109_().m_6836_(i, new ItemStack((ItemLike)itemstack.m_41720_(), count - taken));
            amountFound += taken;
        }
        if (needsTwo) {
            if (amountFound % 2 != 0) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)required));
            }
            amountFound /= 2;
        }
        return amountFound;
    }

    public static ItemStack getRequiredItem(BlockState state) {
        ItemStack itemStack = new ItemStack((ItemLike)state.m_60734_());
        Item item = itemStack.m_41720_();
        if (item == Items.f_41961_ || item == Items.f_151032_) {
            itemStack = new ItemStack((ItemLike)Items.f_42329_);
        }
        return itemStack;
    }

    public static void destroyBlock(Level world, BlockPos pos, float effectChance) {
        BlockHelper.destroyBlock(world, pos, effectChance, stack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack));
    }

    public static void destroyBlock(Level world, BlockPos pos, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        BlockHelper.destroyBlockAs(world, pos, null, ItemStack.f_41583_, effectChance, droppedItemCallback);
    }

    public static void destroyBlockAs(Level world, BlockPos pos, @Nullable Player player, ItemStack usedTool, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        BlockEntity tileentity;
        FluidState fluidState = world.m_6425_(pos);
        BlockState state = world.m_8055_(pos);
        if (world.f_46441_.nextFloat() < effectChance) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        BlockEntity blockEntity = tileentity = state.m_155947_() ? world.m_7702_(pos) : null;
        if (player != null) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            if (event.getExpToDrop() > 0 && world instanceof ServerLevel) {
                state.m_60734_().m_49805_((ServerLevel)world, pos, event.getExpToDrop());
            }
            usedTool.m_41686_(world, state, pos, player);
            player.m_36246_(Stats.f_12949_.m_12902_((Object)state.m_60734_()));
        }
        if (world instanceof ServerLevel && world.m_46469_().m_46207_(GameRules.f_46136_) && !world.restoringBlockSnapshots && (player == null || !player.m_7500_())) {
            for (ItemStack itemStack : Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)tileentity, (Entity)player, (ItemStack)usedTool)) {
                droppedItemCallback.accept(itemStack);
            }
            state.m_60612_((ServerLevel)world, pos, ItemStack.f_41583_);
        }
        world.m_46597_(pos, fluidState.m_76188_());
    }

    public static boolean isSolidWall(BlockGetter reader, BlockPos fromPos, Direction toDirection) {
        return BlockHelper.hasBlockSolidSide(reader.m_8055_(fromPos.m_142300_(toDirection)), reader, fromPos.m_142300_(toDirection), toDirection.m_122424_());
    }

    public static boolean noCollisionInSpace(BlockGetter reader, BlockPos pos) {
        return reader.m_8055_(pos).m_60812_(reader, pos).m_83281_();
    }

    private static void placeRailWithoutUpdate(Level world, BlockState state, BlockPos target) {
        int idx;
        LevelChunk chunk = world.m_46745_(target);
        LevelChunkSection chunksection = chunk.m_183278_(idx = chunk.m_151564_(target.m_123342_()));
        if (chunksection == null) {
            chunk.m_7103_()[idx] = chunksection = new LevelChunkSection(chunk.m_151568_(idx), world.m_5962_().m_175515_(Registry.f_122885_));
        }
        BlockState old = chunksection.m_62986_(SectionPos.m_123207_((int)target.m_123341_()), SectionPos.m_123207_((int)target.m_123342_()), SectionPos.m_123207_((int)target.m_123343_()), state);
        chunk.m_8092_(true);
        world.markAndNotifyBlock(target, chunk, old, state, 82, 512);
        world.m_7731_(target, state, 82);
        world.m_46586_(target, world.m_8055_(target.m_7495_()).m_60734_(), target.m_7495_());
    }

    public static void placeSchematicBlock(Level world, BlockState state, BlockPos target, ItemStack stack, @Nullable CompoundTag data) {
        BlockEntity tile;
        if (state.m_61138_((Property)BlockStateProperties.f_61432_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61432_, (Comparable)Boolean.FALSE);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE);
        }
        if (AllBlocks.BELT.has(state)) {
            world.m_7731_(target, state, 2);
            return;
        }
        if (state.m_60734_() == Blocks.f_50715_) {
            state = Blocks.f_50715_.m_49966_();
        } else if (state.m_60734_() != Blocks.f_50567_ && state.m_60734_() instanceof IPlantable) {
            state = ((IPlantable)state.m_60734_()).getPlant((BlockGetter)world, target);
        }
        if (world.m_6042_().m_63951_() && state.m_60819_().m_76152_().m_76108_((Tag)FluidTags.f_13131_)) {
            int i = target.m_123341_();
            int j = target.m_123342_();
            int k = target.m_123343_();
            world.m_5594_(null, target, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            Block.m_49950_((BlockState)state, (Level)world, (BlockPos)target);
            return;
        }
        if (state.m_60734_() instanceof BaseRailBlock) {
            BlockHelper.placeRailWithoutUpdate(world, state, target);
        } else {
            world.m_7731_(target, state, 18);
        }
        if (data != null && (tile = world.m_7702_(target)) != null) {
            data.m_128405_("x", target.m_123341_());
            data.m_128405_("y", target.m_123342_());
            data.m_128405_("z", target.m_123343_());
            if (tile instanceof KineticTileEntity) {
                ((KineticTileEntity)tile).warnOfMovement();
            }
            tile.m_142466_(data);
        }
        try {
            state.m_60734_().m_6402_(world, target, state, null, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static double getBounceMultiplier(Block block) {
        if (block instanceof SlimeBlock) {
            return 0.8;
        }
        if (block instanceof BedBlock || block instanceof SeatBlock) {
            return 0.528;
        }
        return 0.0;
    }

    public static boolean hasBlockSolidSide(BlockState p_220056_0_, BlockGetter p_220056_1_, BlockPos p_220056_2_, Direction p_220056_3_) {
        return !p_220056_0_.m_60620_((Tag)BlockTags.f_13035_) && Block.m_49918_((VoxelShape)p_220056_0_.m_60812_(p_220056_1_, p_220056_2_), (Direction)p_220056_3_);
    }

    public static boolean extinguishFire(Level world, @Nullable Player p_175719_1_, BlockPos p_175719_2_, Direction p_175719_3_) {
        if (world.m_8055_(p_175719_2_ = p_175719_2_.m_142300_(p_175719_3_)).m_60734_() == Blocks.f_50083_) {
            world.m_5898_(p_175719_1_, 1009, p_175719_2_, 0);
            world.m_7471_(p_175719_2_, false);
            return true;
        }
        return false;
    }

    public static BlockState copyProperties(BlockState fromState, BlockState toState) {
        for (Property property : fromState.m_61147_()) {
            toState = BlockHelper.copyProperty(property, fromState, toState);
        }
        return toState;
    }

    public static <T extends Comparable<T>> BlockState copyProperty(Property<T> property, BlockState fromState, BlockState toState) {
        if (fromState.m_61138_(property) && toState.m_61138_(property)) {
            return (BlockState)toState.m_61124_(property, fromState.m_61143_(property));
        }
        return toState;
    }
}

