/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ScrollValueRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        Direction face = result.m_82434_();
        ScrollValueBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, pos, ScrollValueBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.needsWrench && !AllItems.WRENCH.isIn(mc.f_91074_.m_21205_())) {
            return;
        }
        boolean highlight = behaviour.testHit(target.m_82450_());
        if (behaviour instanceof BulkScrollValueBehaviour && AllKeys.ctrlDown()) {
            BulkScrollValueBehaviour bulkScrolling = (BulkScrollValueBehaviour)behaviour;
            for (SmartTileEntity smartTileEntity : bulkScrolling.getBulk()) {
                ScrollValueBehaviour other = smartTileEntity.getBehaviour(ScrollValueBehaviour.TYPE);
                if (other == null) continue;
                ScrollValueRenderer.addBox(world, smartTileEntity.m_58899_(), face, other, highlight);
            }
        } else {
            ScrollValueRenderer.addBox(world, pos, face, behaviour, highlight);
        }
    }

    protected static void addBox(ClientLevel world, BlockPos pos, Direction face, ScrollValueBehaviour behaviour, boolean highlight) {
        ValueBox box;
        AABB bb = new AABB(Vec3.f_82478_, Vec3.f_82478_).m_82400_(0.5).m_82310_(0.0, 0.0, -0.5).m_82386_(0.0, 0.0, -0.125);
        Component label = behaviour.label;
        if (behaviour instanceof ScrollOptionBehaviour) {
            box = new ValueBox.IconValueBox(label, ((ScrollOptionBehaviour)behaviour).getIconForSelected(), bb, pos);
        } else {
            box = new ValueBox.TextValueBox(label, bb, pos, (Component)new TextComponent(behaviour.formatValue()));
            if (behaviour.unit != null) {
                box.subLabel((Component)new TextComponent("(").m_7220_(behaviour.unit.apply(behaviour.scrollableValue)).m_130946_(")"));
            }
        }
        box.scrollTooltip((Component)new TextComponent("[").m_7220_((Component)Lang.translate("action.scroll", new Object[0])).m_130946_("]"));
        box.offsetLabel(behaviour.textShift.m_82520_(20.0, -10.0, 0.0)).withColors(0x5A5D5A, 11909046).passive(!highlight);
        CreateClient.OUTLINER.showValueBox(pos, box.transform(behaviour.slotPositioning)).lineWidth(0.015625f).highlightFace(face);
    }
}

