/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.content.logistics.item.filter.attribute.BookAuthorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.BookCopyAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ColorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.EnchantAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.FluidContentsAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemNameAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ShulkerFillLevelAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery.AstralSorceryAmuletAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery.AstralSorceryAttunementAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery.AstralSorceryCrystalAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.astralsorcery.AstralSorceryPerkGemAttribute;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.StringUtils;

public interface ItemAttribute {
    public static final List<ItemAttribute> types = new ArrayList<ItemAttribute>();
    public static final ItemAttribute standard = ItemAttribute.register(StandardTraits.DUMMY);
    public static final ItemAttribute inTag = ItemAttribute.register(new InTag(new ResourceLocation("dummy")));
    public static final ItemAttribute inItemGroup = ItemAttribute.register(new InItemGroup(CreativeModeTab.f_40753_));
    public static final ItemAttribute addedBy = ItemAttribute.register(new AddedBy("dummy"));
    public static final ItemAttribute hasEnchant = ItemAttribute.register(EnchantAttribute.EMPTY);
    public static final ItemAttribute shulkerFillLevel = ItemAttribute.register(ShulkerFillLevelAttribute.EMPTY);
    public static final ItemAttribute hasColor = ItemAttribute.register(ColorAttribute.EMPTY);
    public static final ItemAttribute hasFluid = ItemAttribute.register(FluidContentsAttribute.EMPTY);
    public static final ItemAttribute hasName = ItemAttribute.register(new ItemNameAttribute("dummy"));
    public static final ItemAttribute bookAuthor = ItemAttribute.register(new BookAuthorAttribute("dummy"));
    public static final ItemAttribute bookCopy = ItemAttribute.register(new BookCopyAttribute(-1));
    public static final ItemAttribute astralAmulet = ItemAttribute.register(new AstralSorceryAmuletAttribute("dummy", -1));
    public static final ItemAttribute astralAttunement = ItemAttribute.register(new AstralSorceryAttunementAttribute("dummy"));
    public static final ItemAttribute astralCrystal = ItemAttribute.register(new AstralSorceryCrystalAttribute("dummy"));
    public static final ItemAttribute astralPerkGem = ItemAttribute.register(new AstralSorceryPerkGemAttribute("dummy"));

    public static ItemAttribute register(ItemAttribute attributeType) {
        types.add(attributeType);
        return attributeType;
    }

    default public boolean appliesTo(ItemStack stack, Level world) {
        return this.appliesTo(stack);
    }

    public boolean appliesTo(ItemStack var1);

    default public List<ItemAttribute> listAttributesOf(ItemStack stack, Level world) {
        return this.listAttributesOf(stack);
    }

    public List<ItemAttribute> listAttributesOf(ItemStack var1);

    public String getTranslationKey();

    public void writeNBT(CompoundTag var1);

    public ItemAttribute readNBT(CompoundTag var1);

    default public void serializeNBT(CompoundTag nbt) {
        CompoundTag compound = new CompoundTag();
        this.writeNBT(compound);
        nbt.m_128365_(this.getNBTKey(), (Tag)compound);
    }

    public static ItemAttribute fromNBT(CompoundTag nbt) {
        for (ItemAttribute itemAttribute : types) {
            if (!itemAttribute.canRead(nbt)) continue;
            return itemAttribute.readNBT(nbt.m_128469_(itemAttribute.getNBTKey()));
        }
        return null;
    }

    default public Object[] getTranslationParameters() {
        return new String[0];
    }

    default public boolean canRead(CompoundTag nbt) {
        return nbt.m_128441_(this.getNBTKey());
    }

    default public String getNBTKey() {
        return this.getTranslationKey();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public TranslatableComponent format(boolean inverted) {
        return Lang.translate("item_attributes." + this.getTranslationKey() + (inverted ? ".inverted" : ""), this.getTranslationParameters());
    }

    public static enum StandardTraits implements ItemAttribute
    {
        DUMMY(s -> false),
        PLACEABLE(s -> s.m_41720_() instanceof BlockItem),
        CONSUMABLE(ItemStack::m_41614_),
        FLUID_CONTAINER(s -> s.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()),
        ENCHANTED(ItemStack::m_41793_),
        MAX_ENCHANTED(StandardTraits::maxEnchanted),
        RENAMED(ItemStack::m_41788_),
        DAMAGED(ItemStack::m_41768_),
        BADLY_DAMAGED(s -> s.m_41768_() && (float)(s.m_41773_() / s.m_41776_()) > 0.75f),
        NOT_STACKABLE(((Predicate<ItemStack>)ItemStack::m_41753_).negate()),
        EQUIPABLE(s -> LivingEntity.m_147233_((ItemStack)s).m_20743_() != EquipmentSlot.Type.HAND),
        FURNACE_FUEL(AbstractFurnaceBlockEntity::m_58399_),
        WASHABLE(InWorldProcessing::isWashable),
        HAUNTABLE(InWorldProcessing::isHauntable),
        CRUSHABLE((s, w) -> StandardTraits.testRecipe(s, w, AllRecipeTypes.CRUSHING.getType()) || StandardTraits.testRecipe(s, w, AllRecipeTypes.MILLING.getType())),
        SMELTABLE((s, w) -> StandardTraits.testRecipe(s, w, (RecipeType<? extends Recipe<Container>>)RecipeType.f_44108_)),
        SMOKABLE((s, w) -> StandardTraits.testRecipe(s, w, (RecipeType<? extends Recipe<Container>>)RecipeType.f_44110_)),
        BLASTABLE((s, w) -> StandardTraits.testRecipe(s, w, (RecipeType<? extends Recipe<Container>>)RecipeType.f_44109_));

        private static final RecipeWrapper RECIPE_WRAPPER;
        private Predicate<ItemStack> test;
        private BiPredicate<ItemStack, Level> testWithWorld;

        private StandardTraits(Predicate<ItemStack> test) {
            this.test = test;
        }

        private static boolean testRecipe(ItemStack s, Level w, RecipeType<? extends Recipe<Container>> type) {
            RECIPE_WRAPPER.m_6836_(0, s.m_41777_());
            return w.m_7465_().m_44015_(type, (Container)RECIPE_WRAPPER, w).isPresent();
        }

        private static boolean maxEnchanted(ItemStack s) {
            return EnchantmentHelper.m_44831_((ItemStack)s).entrySet().stream().anyMatch(e -> ((Enchantment)e.getKey()).m_6586_() <= (Integer)e.getValue());
        }

        private StandardTraits(BiPredicate<ItemStack, Level> test) {
            this.testWithWorld = test;
        }

        @Override
        public boolean appliesTo(ItemStack stack, Level world) {
            if (this.testWithWorld != null) {
                return this.testWithWorld.test(stack, world);
            }
            return this.appliesTo(stack);
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return this.test.test(stack);
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack, Level world) {
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            for (StandardTraits trait : StandardTraits.values()) {
                if (!trait.appliesTo(stack, world)) continue;
                attributes.add(trait);
            }
            return attributes;
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            return null;
        }

        @Override
        public String getTranslationKey() {
            return Lang.asId(this.name());
        }

        @Override
        public String getNBTKey() {
            return "standard_trait";
        }

        @Override
        public void writeNBT(CompoundTag nbt) {
            nbt.m_128379_(this.name(), true);
        }

        @Override
        public ItemAttribute readNBT(CompoundTag nbt) {
            for (StandardTraits trait : StandardTraits.values()) {
                if (!nbt.m_128441_(trait.name())) continue;
                return trait;
            }
            return null;
        }

        static {
            RECIPE_WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
        }
    }

    public static class InTag
    implements ItemAttribute {
        public ResourceLocation tagName;

        public InTag(ResourceLocation tagName) {
            this.tagName = tagName;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return stack.m_41720_().getTags().contains(this.tagName);
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            return stack.m_41720_().getTags().stream().map(InTag::new).collect(Collectors.toList());
        }

        @Override
        public String getTranslationKey() {
            return "in_tag";
        }

        @Override
        public Object[] getTranslationParameters() {
            return new Object[]{"#" + this.tagName.toString()};
        }

        @Override
        public void writeNBT(CompoundTag nbt) {
            nbt.m_128359_("space", this.tagName.m_135827_());
            nbt.m_128359_("path", this.tagName.m_135815_());
        }

        @Override
        public ItemAttribute readNBT(CompoundTag nbt) {
            return new InTag(new ResourceLocation(nbt.m_128461_("space"), nbt.m_128461_("path")));
        }
    }

    public static class InItemGroup
    implements ItemAttribute {
        private CreativeModeTab group;

        public InItemGroup(CreativeModeTab group) {
            this.group = group;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            Item item = stack.m_41720_();
            return item.m_41471_() == this.group;
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            CreativeModeTab group = stack.m_41720_().m_41471_();
            return group == null ? Collections.emptyList() : Arrays.asList(new InItemGroup(group));
        }

        @Override
        public String getTranslationKey() {
            return "in_item_group";
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public TranslatableComponent format(boolean inverted) {
            return Lang.translate("item_attributes." + this.getTranslationKey() + (inverted ? ".inverted" : ""), this.group.m_40786_());
        }

        @Override
        public void writeNBT(CompoundTag nbt) {
            nbt.m_128359_("path", this.group.m_40783_());
        }

        @Override
        public ItemAttribute readNBT(CompoundTag nbt) {
            String readPath = nbt.m_128461_("path");
            for (CreativeModeTab group : CreativeModeTab.f_40748_) {
                if (!group.m_40783_().equals(readPath)) continue;
                return new InItemGroup(group);
            }
            return null;
        }
    }

    public static class AddedBy
    implements ItemAttribute {
        private String modId;

        public AddedBy(String modId) {
            this.modId = modId;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return this.modId.equals(stack.m_41720_().getCreatorModId(stack));
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            String id = stack.m_41720_().getCreatorModId(stack);
            return id == null ? Collections.emptyList() : Arrays.asList(new AddedBy(id));
        }

        @Override
        public String getTranslationKey() {
            return "added_by";
        }

        @Override
        public Object[] getTranslationParameters() {
            Optional modContainerById = ModList.get().getModContainerById(this.modId);
            String name = modContainerById.map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(StringUtils.capitalize((String)this.modId));
            return new Object[]{name};
        }

        @Override
        public void writeNBT(CompoundTag nbt) {
            nbt.m_128359_("id", this.modId);
        }

        @Override
        public ItemAttribute readNBT(CompoundTag nbt) {
            return new AddedBy(nbt.m_128461_("id"));
        }
    }
}

