/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced;

import com.simibubi.create.content.contraptions.RotationPropagator;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.motor.CreativeMotorTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SpeedControllerTileEntity
extends KineticTileEntity {
    public static final int DEFAULT_SPEED = 16;
    protected ScrollValueBehaviour targetSpeed;
    boolean hasBracket = false;

    public SpeedControllerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.updateBracket();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        Integer max = (Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get();
        this.targetSpeed = new ScrollValueBehaviour((Component)Lang.translate("generic.speed", new Object[0]), this, new ControllerValueBoxTransform());
        this.targetSpeed.between(-max.intValue(), max);
        this.targetSpeed.value = 16;
        this.targetSpeed.moveText(new Vec3(9.0, 0.0, 10.0));
        this.targetSpeed.withUnit(i -> Lang.translate("generic.unit.rpm", new Object[0]));
        this.targetSpeed.withCallback(i -> this.updateTargetRotation());
        this.targetSpeed.withStepFunction(CreativeMotorTileEntity::step);
        behaviours.add(this.targetSpeed);
    }

    private void updateTargetRotation() {
        if (this.hasNetwork()) {
            this.getOrCreateNetwork().remove(this);
        }
        RotationPropagator.handleRemoved(this.f_58857_, this.f_58858_, this);
        this.removeSource();
        this.attachKinetics();
    }

    public static float getConveyedSpeed(KineticTileEntity cogWheel, KineticTileEntity speedControllerIn, boolean targetingController) {
        float compareSpeed;
        if (!(speedControllerIn instanceof SpeedControllerTileEntity)) {
            return 0.0f;
        }
        float speed = speedControllerIn.getTheoreticalSpeed();
        float wheelSpeed = cogWheel.getTheoreticalSpeed();
        float desiredOutputSpeed = SpeedControllerTileEntity.getDesiredOutputSpeed(cogWheel, speedControllerIn, targetingController);
        float f = compareSpeed = targetingController ? speed : wheelSpeed;
        if (desiredOutputSpeed >= 0.0f && compareSpeed >= 0.0f) {
            return Math.max(desiredOutputSpeed, compareSpeed);
        }
        if (desiredOutputSpeed < 0.0f && compareSpeed < 0.0f) {
            return Math.min(desiredOutputSpeed, compareSpeed);
        }
        return desiredOutputSpeed;
    }

    public static float getDesiredOutputSpeed(KineticTileEntity cogWheel, KineticTileEntity speedControllerIn, boolean targetingController) {
        SpeedControllerTileEntity speedController = (SpeedControllerTileEntity)speedControllerIn;
        float targetSpeed = speedController.targetSpeed.getValue();
        float speed = speedControllerIn.getTheoreticalSpeed();
        float wheelSpeed = cogWheel.getTheoreticalSpeed();
        if (targetSpeed == 0.0f) {
            return 0.0f;
        }
        if (targetingController && wheelSpeed == 0.0f) {
            return 0.0f;
        }
        if (!speedController.hasSource()) {
            if (targetingController) {
                return targetSpeed;
            }
            return 0.0f;
        }
        boolean wheelPowersController = speedController.source.equals((Object)cogWheel.m_58899_());
        if (wheelPowersController) {
            if (targetingController) {
                return targetSpeed;
            }
            return wheelSpeed;
        }
        if (targetingController) {
            return speed;
        }
        return targetSpeed;
    }

    public void updateBracket() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        BlockState stateAbove = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        this.hasBracket = ICogWheel.isDedicatedCogWheel(stateAbove.m_60734_()) && ICogWheel.isLargeCog(stateAbove) && ((Direction.Axis)stateAbove.m_61143_((Property)CogWheelBlock.AXIS)).m_122479_();
    }

    private class ControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        private ControllerValueBoxTransform() {
        }

        @Override
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 11.0, 16.0);
        }

        @Override
        protected boolean isSideActive(BlockState state, Direction direction) {
            if (direction.m_122434_().m_122478_()) {
                return false;
            }
            return state.m_61143_(SpeedControllerBlock.HORIZONTAL_AXIS) != direction.m_122434_();
        }

        @Override
        protected float getScale() {
            return 0.275f;
        }
    }
}

