/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.contraptions.fluids.pipes.StraightPipeTileEntity;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.fluids.FluidStack;

public class TransparentStraightPipeRenderer
extends SafeTileEntityRenderer<StraightPipeTileEntity> {
    public TransparentStraightPipeRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(StraightPipeTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        FluidTransportBehaviour pipe = te.getBehaviour(FluidTransportBehaviour.TYPE);
        if (pipe == null) {
            return;
        }
        for (Direction side : Iterate.directions) {
            LerpedFloat progress;
            FluidStack fluidStack;
            PipeConnection.Flow flow = pipe.getFlow(side);
            if (flow == null || (fluidStack = flow.fluid).isEmpty() || (progress = flow.progress) == null) continue;
            float value = progress.getValue(partialTicks);
            boolean inbound = flow.inbound;
            if (value == 1.0f) {
                if (inbound) {
                    PipeConnection.Flow opposite = pipe.getFlow(side.m_122424_());
                    if (opposite == null) {
                        value -= 1.0E-6f;
                    }
                } else {
                    FluidTransportBehaviour adjacent = TileEntityBehaviour.get((BlockGetter)te.m_58904_(), te.m_58899_().m_142300_(side), FluidTransportBehaviour.TYPE);
                    if (adjacent == null) {
                        value -= 1.0E-6f;
                    } else {
                        PipeConnection.Flow other = adjacent.getFlow(side.m_122424_());
                        if (other == null || !other.inbound && !other.complete) {
                            value -= 1.0E-6f;
                        }
                    }
                }
            }
            FluidRenderer.renderFluidStream(fluidStack, side, 0.1875f, value, inbound, buffer, ms, light);
        }
    }
}

