/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlStateTracker;
import com.jozufozu.flywheel.backend.instancing.Engine;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.instancing.SerialTaskEngine;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.BatchingEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.backend.model.ArrayModelRenderer;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.core.model.WorldModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionGroup;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionInstanceManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderInfo;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FlwContraption
extends ContraptionRenderInfo {
    private final ContraptionLighter<?> lighter;
    private final Map<RenderType, ArrayModelRenderer> renderLayers = new HashMap<RenderType, ArrayModelRenderer>();
    private final Matrix4f modelViewPartial = new Matrix4f();
    private final ContraptionInstanceWorld instanceWorld;
    private boolean modelViewPartialReady;
    private AABB lightBox;

    public FlwContraption(Contraption contraption, VirtualRenderWorld renderWorld) {
        super(contraption, renderWorld);
        this.lighter = contraption.makeLighter();
        this.instanceWorld = new ContraptionInstanceWorld(this);
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        this.buildLayers();
        if (Backend.isOn()) {
            this.buildInstancedTiles();
            this.buildActors();
        }
        restoreState.restore();
    }

    public ContraptionLighter<?> getLighter() {
        return this.lighter;
    }

    public void renderStructureLayer(RenderType layer, ContraptionProgram shader) {
        ArrayModelRenderer structure = this.renderLayers.get(layer);
        if (structure != null) {
            this.setup(shader);
            structure.draw();
        }
    }

    public void renderInstanceLayer(RenderLayerEvent event) {
        event.stack.m_85836_();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        AbstractContraptionEntity entity = this.contraption.entity;
        double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        event.stack.m_85837_(x - event.camX, y - event.camY, z - event.camZ);
        ContraptionMatrices.transform(event.stack, this.getMatrices().getModel());
        this.instanceWorld.engine.render((TaskEngine)SerialTaskEngine.INSTANCE, event);
        event.stack.m_85849_();
    }

    @Override
    public void beginFrame(BeginFrameEvent event) {
        super.beginFrame(event);
        this.modelViewPartial.m_27624_();
        this.modelViewPartialReady = false;
        if (!this.isVisible()) {
            return;
        }
        this.instanceWorld.tileInstanceManager.beginFrame((TaskEngine)SerialTaskEngine.INSTANCE, event.getCamera());
        Vec3 cameraPos = event.getCameraPos();
        this.lightBox = this.lighter.lightVolume.toAABB().m_82386_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
    }

    @Override
    public void setupMatrices(PoseStack viewProjection, double camX, double camY, double camZ) {
        super.setupMatrices(viewProjection, camX, camY, camZ);
        if (!this.modelViewPartialReady) {
            FlwContraption.setupModelViewPartial(this.modelViewPartial, this.getMatrices().getModel().m_85850_().m_85861_(), this.contraption.entity, camX, camY, camZ, AnimationTickHolder.getPartialTicks());
            this.modelViewPartialReady = true;
        }
    }

    void setup(ContraptionProgram shader) {
        if (!this.modelViewPartialReady || this.lightBox == null) {
            return;
        }
        shader.bind(this.modelViewPartial, this.lightBox);
        this.lighter.lightVolume.bind();
    }

    @Override
    public void invalidate() {
        for (ArrayModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        this.lighter.delete();
        this.instanceWorld.delete();
    }

    private void buildLayers() {
        for (ArrayModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        List blockLayers = RenderType.m_110506_();
        for (RenderType layer : blockLayers) {
            WorldModel layerModel = new WorldModel((BlockAndTintGetter)this.renderWorld, layer, this.contraption.getBlocks().values(), layer + "_" + this.contraption.entity.m_142049_());
            this.renderLayers.put(layer, new ArrayModelRenderer((Model)layerModel));
        }
    }

    private void buildInstancedTiles() {
        List<BlockEntity> tileEntities = this.contraption.maybeInstancedTileEntities;
        if (!tileEntities.isEmpty()) {
            for (BlockEntity te : tileEntities) {
                if (!InstancedRenderRegistry.canInstance((BlockEntityType)te.m_58903_())) continue;
                Level world = te.m_58904_();
                te.m_142339_((Level)this.renderWorld);
                this.instanceWorld.tileInstanceManager.add(te);
                te.m_142339_(world);
            }
        }
    }

    private void buildActors() {
        this.contraption.getActors().forEach(this.instanceWorld.tileInstanceManager::createActor);
    }

    public static void setupModelViewPartial(Matrix4f matrix, Matrix4f modelMatrix, AbstractContraptionEntity entity, double camX, double camY, double camZ, float pt) {
        float x = (float)(Mth.m_14139_((double)pt, (double)entity.f_19790_, (double)entity.m_20185_()) - camX);
        float y = (float)(Mth.m_14139_((double)pt, (double)entity.f_19791_, (double)entity.m_20186_()) - camY);
        float z = (float)(Mth.m_14139_((double)pt, (double)entity.f_19792_, (double)entity.m_20189_()) - camZ);
        matrix.setTranslation(x, y, z);
        matrix.m_27644_(modelMatrix);
    }

    public void tick() {
        this.instanceWorld.tileInstanceManager.tick();
    }

    public static class ContraptionInstanceWorld {
        private final Engine engine;
        private final ContraptionInstanceManager tileInstanceManager;

        public ContraptionInstanceWorld(FlwContraption parent) {
            switch (Backend.getEngine()) {
                case INSTANCING: {
                    InstancingEngine engine = InstancingEngine.builder(CreateContexts.CWORLD).setGroupFactory(ContraptionGroup.forContraption(parent)).setIgnoreOriginCoordinate(true).build();
                    this.tileInstanceManager = new ContraptionInstanceManager((MaterialManager)engine, parent.renderWorld);
                    engine.addListener((InstancingEngine.OriginShiftListener)this.tileInstanceManager);
                    this.engine = engine;
                    break;
                }
                case BATCHING: {
                    this.engine = new BatchingEngine();
                    this.tileInstanceManager = new ContraptionInstanceManager((MaterialManager)this.engine, parent.renderWorld);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown engine type");
                }
            }
        }

        public void delete() {
            this.engine.delete();
            this.tileInstanceManager.invalidate();
        }
    }
}

