/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WindmillBearingTileEntity
extends MechanicalBearingTileEntity {
    protected ScrollOptionBehaviour<RotationDirection> movementDirection;
    protected float lastGeneratedSpeed;

    public WindmillBearingTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void updateGeneratedRotation() {
        super.updateGeneratedRotation();
        this.lastGeneratedSpeed = this.getGeneratedSpeed();
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        boolean cancelAssembly = this.assembleNextTick;
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = cancelAssembly;
    }

    @Override
    public float getGeneratedSpeed() {
        if (!this.running) {
            return 0.0f;
        }
        if (this.movedContraption == null) {
            return this.lastGeneratedSpeed;
        }
        int sails = ((BearingContraption)this.movedContraption.getContraption()).getSailBlocks() / (Integer)AllConfigs.SERVER.kinetics.windmillSailsPerRPM.get();
        return (float)Mth.m_14045_((int)sails, (int)1, (int)16) * this.getAngleSpeedDirection();
    }

    @Override
    protected boolean isWindmill() {
        return true;
    }

    protected float getAngleSpeedDirection() {
        RotationDirection rotationDirection = RotationDirection.values()[this.movementDirection.getValue()];
        return rotationDirection == RotationDirection.CLOCKWISE ? 1 : -1;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("LastGenerated", this.lastGeneratedSpeed);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        if (!this.wasMoved) {
            this.lastGeneratedSpeed = compound.m_128457_("LastGenerated");
        }
        super.read(compound, clientPacket);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.remove(this.movementMode);
        this.movementDirection = new ScrollOptionBehaviour<RotationDirection>(RotationDirection.class, (Component)Lang.translate("contraptions.windmill.rotation_direction", new Object[0]), this, this.getMovementModeSlot());
        this.movementDirection.requiresWrench();
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add(this.movementDirection);
    }

    private void onDirectionChanged() {
        if (!this.running) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public boolean isWoodenTop() {
        return true;
    }

    static enum RotationDirection implements INamedIconOptions
    {
        CLOCKWISE(AllIcons.I_REFRESH),
        COUNTER_CLOCKWISE(AllIcons.I_ROTATE_CCW);

        private String translationKey;
        private AllIcons icon;

        private RotationDirection(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "generic." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

